jiraDevelopmentIntegrationPluginJsonp([12],{

/***/ "./js/util/DevStatusLocalStorage.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jira-logger/require('jira/util/logger')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')"), __webpack_require__("./js/util/LocalStorage.js")], __WEBPACK_AMD_DEFINE_RESULT__ = function (logger, _, localStorage) {
    'use strict';

    var devStatusLocalStorage = _.extend({}, localStorage);
    devStatusLocalStorage.setItem = function (key, value) {
        try {
            localStorage.setItem(key, value);
        } catch (err) {
            var info = '';
            // Error code 22 is a QuotaExceededException on Chrome and Edge
            // Error code 1014 with name 'NS_ERROR_DOM_QUOTA_REACHED' is a QuotaExceededException on Firefox
            if (err.code === 22 || err.code === 1014 && err.name === 'NS_ERROR_DOM_QUOTA_REACHED') {
                info = '. Browser local storage is full. For more information please follow ' + 'https://confluence.atlassian.com/jirakb/functionality-in-jira-fails-due-to-exceeding-chrome-quota-762874705.html';
            }
            logger.error("Couldn't store '" + key + "' & '" + value + "' key-value pair locally: " + err.name + info);
        }
    };
    devStatusLocalStorage.getItem = function (key) {
        try {
            return localStorage.getItem(key);
        } catch (err) {
            logger.error("Couldn't retrieve locally stored value for key '" + key + "': " + err.name);
        }
    };
    devStatusLocalStorage.removeItem = function (key) {
        try {
            localStorage.removeItem(key);
        } catch (err) {
            logger.error("Couldn't remove locally stored value for key '" + key + "': " + err.name);
        }
    };
    devStatusLocalStorage.clear = function () {
        try {
            localStorage.clear();
        } catch (err) {
            logger.error("Couldn't clear local storage: " + err.name);
        }
    };
    return devStatusLocalStorage;
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/util/Helpers.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:wrm-context-path/require('wrm/context-path')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (wrmContextPath, _) {
    'use strict';

    /**
     * Return a function to mark a string object as sanitised so that soy doesn't escape it.
     *
     * We can remove this and just use soydata.VERY_UNSAFE.ordainSanitizedHtml once we only support JIRA >= 7
     *
     * @returns a function to sanitise a string for unescaped usage in a soy template.
     */

    var sanitiserFunction = function sanitiserFunction() {
        if (soydata.VERY_UNSAFE) {
            return soydata.VERY_UNSAFE.ordainSanitizedHtml;
        } else {
            return function (stringToMarkAsSafe) {
                return new soydata.SanitizedHtml(stringToMarkAsSafe);
            };
        }
    };

    return {
        getContextPath: wrmContextPath,

        /**
         * Make a copy of object with all String properties of this new object marked as sanitised html,
         * so that soy doesn't try to escape them if we use the strings in a soy template context.
         *
         * DO NOT sanitise strings to be used in a soy template unless you know they are safe.
         *
         * @param object {Object} has some string properties that we want to sanitise so that soy doesn't escape them
         * @return object {Object} a copy of object with the string properties marked as sanitised
         */
        copyAndMarkStringPropertiesAsSanitised: function copyAndMarkStringPropertiesAsSanitised(object) {
            var sanitiserFn = sanitiserFunction();
            var sanitisedObject = Array.isArray(object) ? [] : {};
            _.each(_.keys(object), function (key) {
                var val = object[key];
                if (val) {
                    if (typeof val === 'string') {
                        sanitisedObject[key] = sanitiserFn(val);
                    } else if ((typeof val === 'undefined' ? 'undefined' : _typeof(val)) === 'object') {
                        if (_.keys(val).length > 0) {
                            sanitisedObject[key] = copyAndMarkStringPropertiesAsSanitised(val);
                        }
                    } else {
                        sanitisedObject[key] = val;
                    }
                }
            });
            return sanitisedObject;
        }
    };
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/util/LocalStorage.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_RESULT__;

!(__WEBPACK_AMD_DEFINE_RESULT__ = function () {
    'use strict';

    if (!localStorage) {
        return {
            setItem: function setItem() {},
            getItem: function getItem() {},
            removeItem: function removeItem() {},
            clear: function clear() {}
        };
    }
    return localStorage;
}.call(exports, __webpack_require__, exports, module),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/viewissue/dialog/BaseDetailDialogModel.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

// @formatter:off

!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:wrm-context-path/require('wrm/context-path')"), __webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')"), __webpack_require__("jira.webresources:jquery/require('jquery')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')")], __WEBPACK_AMD_DEFINE_RESULT__ = function (wrmContextPath, Backbone, $, _) {
    return Backbone.Model.extend({
        TAB_PREFIX: '#tab-menu-',
        PANE_PREFIX: '#tab-content-',

        properties: ['tabs', 'contentMap', //map of instance id to content json
        'oauthStatuses', // authentication status of each remote instance
        'selectedTab', 'selectedPane'],

        namedEvents: [
        // events related to detailed data rest call
        'fetchRequested', 'fetchFailed', 'fetchSucceeded',
        // events related to auth status rest call
        'fetchAuthRequested', 'fetchAuthFailed', 'fetchAuthSucceeded'],

        initialize: function initialize(data) {
            this.issueKey = data.issueKey;
            this.issueId = data.issueId;
            this.type = data.dataType;
            this.set('contentMap', {});
            this.set('tabs', data.tabs);
        },

        switchTab: function switchTab(applicationType, forceFetch) {
            this.set('selectedTab', this.TAB_PREFIX + applicationType);
            this.set('selectedPane', this.PANE_PREFIX + applicationType);

            if (this.get('contentMap')[applicationType] == null || forceFetch) {
                this._fetchContents(applicationType);
            }
        },

        _fetchContents: function _fetchContents(applicationType) {
            this.trigger('fetchRequested', applicationType);
            this._handleFetch(applicationType, $.ajax({
                url: wrmContextPath() + '/rest/dev-status/1.0/issue/detail',
                data: {
                    issueId: this.issueId,
                    applicationType: applicationType,
                    dataType: this.type
                }
            }).promise());
        },

        _handleFetch: function _handleFetch(applicationType, fetchXhr) {
            var instance = this;
            //noinspection JSUnusedLocalSymbols
            fetchXhr.done(function (result) {
                instance._fireSuccessResult(applicationType, result);
            }).fail(function (xhr, status) {
                instance._fireFailResult(applicationType, xhr);
            });
        },

        _fireSuccessResult: function _fireSuccessResult(applicationType, result) {
            this._updateContents(applicationType, result);
            this.trigger('fetchSucceeded', applicationType, result);
        },

        _fireFailResult: function _fireFailResult(applicationType, xhr) {
            this._updateContents(applicationType);
            this.trigger('fetchFailed', applicationType, xhr);
        },

        _updateContents: function _updateContents(applicationType, content) {
            this.get('contentMap')[applicationType] = content;
        },

        /**
        * Initiate the rest call to fetch authentication statuses based on the application types from the current tabs.
        */
        fetchAuthenticationStatuses: function fetchAuthenticationStatuses() {
            var applicationTypes = _.keys(this.get('tabs') || {});
            if (!_.isEmpty(applicationTypes)) {
                var instance = this;
                //noinspection JSUnusedLocalSymbols
                $.ajax({
                    url: wrmContextPath() + '/rest/dev-status/1.0/provider/auth-status',
                    data: {
                        applicationType: applicationTypes
                    }
                }).promise().done(function (result) {
                    if (result && result.data) {
                        instance._updateOAuthStatuses(result.data);
                        instance.trigger('fetchAuthSucceeded', result.data);
                    } else {
                        instance._updateOAuthStatuses();
                        instance.trigger('fetchAuthFailed', null, result);
                    }
                }).fail(function (xhr, status) {
                    instance._updateOAuthStatuses();
                    instance.trigger('fetchAuthFailed', xhr);
                });
            }
        },

        /**
        * Handle the change of oauth status of an instance belonging to an application type.
        * If it's the current tab, triggers the refresh of the current tab by starting the fetch of detailed data.
        * If it's not the current tab but it's content is cached, invalidate the cache.
        */
        oauthStatusChanged: function oauthStatusChanged(applicationType) {
            if (_.has(this.get('tabs'), applicationType)) {
                var currentApplicationType = this._getCurrentApplicationType();
                if (currentApplicationType === applicationType) {
                    this._fetchContents(currentApplicationType);
                } else {
                    // clear the cache, regardless of whether it's there
                    this.get('contentMap')[applicationType] = null;
                }
            }
        },

        _getCurrentApplicationType: function _getCurrentApplicationType() {
            var selectedTab = this.get('selectedTab');
            if (selectedTab) {
                return selectedTab.slice(this.TAB_PREFIX.length);
            }
            return null;
        },

        _updateOAuthStatuses: function _updateOAuthStatuses(content) {
            this.set('oauthStatuses', content);
        }
    });
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/viewissue/dialog/BaseDetailDialogView.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

__webpack_require__(2);
__webpack_require__(12);
__webpack_require__(13);
__webpack_require__(14);
__webpack_require__(15);
__webpack_require__(1);

__webpack_require__(3);

// @formatter:off
/**
 * This is the generic abstract backbone view for the detail dialog
 */
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jira-logger/require('jira/util/logger')"), __webpack_require__("jira.webresources:jira-formatter/require('jira/util/formatter')"), __webpack_require__("jira.webresources:dialogs/require('jira/dialog/form-dialog')"), __webpack_require__("jira.webresources:wrm-context-path/require('wrm/context-path')"), __webpack_require__("jira.webresources:ajs-backbone-amd-shim/require('backbone')"), __webpack_require__("jira.webresources:jquery/require('jquery')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')"), __webpack_require__("./js/util/DevStatusLocalStorage.js"), __webpack_require__], __WEBPACK_AMD_DEFINE_RESULT__ = function (logger, formatter, FormDialog, wrmContextPath, Backbone, $, _, detailDialogLocalStorage, require) {
    var devStatusNavigate = __webpack_require__("./js/util/DevStatusNavigation.js");
    var JIRADevStatusBaseDetailDialogModel = __webpack_require__("./js/viewissue/dialog/BaseDetailDialogModel.js");

    return Backbone.View.extend({
        frameEvents: {
            'click .menu-item': '_doTabClick'
        },

        frameTemplate: JIRA.Templates.DevStatus.DetailDialogFrame.frame,
        oauthStatusTemplate: JIRA.Templates.DevStatus.DetailDialog.oauthStatus,
        authenticationTemplate: JIRA.Templates.DevStatus.DetailDialog.authenticationScreen,
        connectionProblemTemplate: JIRA.Templates.DevStatus.DetailDialog.connectionProblemScreen,
        connectionProblemWarningTemplate: JIRA.Templates.DevStatus.connectionProblemAsWarning,
        noPermissionToViewAllTemplate: JIRA.Templates.DevStatus.DetailDialog.noPermissionToViewAll,
        oauthDanceFailedTemplate: JIRA.Templates.DevStatus.DetailDialog.oauthDanceFailed,

        /**
        * @param options
        * @param options.id {String} Dialog id
        * @param options.issueKey {String} Issue key
        * @param options.issueId {String} Issue id
        * @param options.count {Number} Number of the associated type
        * @param options.model {Backbone.Model} Optional, if none is given, then JIRA.DevStatus.BaseDetailDialogModel will be used
        * @param options.tabs {[{name: String, count: Number}]} A list of map containing name, type and count
        * @param options.type {String} The type of this dialog. Will be used as part of i18n.
        * @param options.dataType {String} the type of remote data (different from type)
        * @param options.width {Number} Width of the content area (does not include frame)
        * @param options.height {Number} Height of the content area (does not include frame)
        * @param options.initialTab {String} The application type of the tab to be active on open
        */
        initialize: function initialize(options) {
            this.options = _.defaults({}, options, {
                width: 560,
                model: new JIRADevStatusBaseDetailDialogModel(options)
            });
            this.model = this.options.model;
            this._initFetchHandlers();

            this._initFormDialog();
        },

        // ===============================================================================
        // The following methods are expected to be extended by the children of this class
        // ===============================================================================
        /**
        * Render the data into the canvas. Note that this is not necessarily the active pane.
        * It is possible that the user switches tab before the data for the tab comes back, in which case
        *  we are rendering the pane of a tab that's not active.
        */
        renderSuccess: function renderSuccess(applicationType, result) {
            return this;
        },
        /**
        * By default, visiting a tab in the detail dialog will cause BaseDetailDialogModel to cache the content
        * of the detail dialog. This is to indicate whether it should make another ajax call.
        */
        shouldRefreshOnTabSwitch: function shouldRefreshOnTabSwitch(applicationType) {
            return false;
        },
        /**
        * Returns the message to be displayed in the title of the detailed dialog.
        * @param count The combined count across all the instances of this entity
        * @param issue The key of the issue currently being displayed
        * @returns {String}
        */
        getTitle: function getTitle(count, issue) {
            // This should never happen
            logger.warn('Unimplemented getTitle() function', this);
            return issue;
        },
        /**
        * Returns the message to be displayed in the footer to inform users that some instances are not authenticated.
        * Override this to display a message specific to the type of dev status, e.g.,
        * "You might be able to see more commits by authenticating with the following servers:"
        * @param instances [Object] the instances that are not authenticated yet. Could be useful for determining plurality.
        * @returns {String}
        */
        getOAuthMessageInFooter: function getOAuthMessageInFooter(instances) {
            return formatter.I18n.getText('devstatus.authentication.message.generic', instances.length);
        },
        /**
        * Returns the message to be displayed in the main canvas of the detailed dialog, when all instances of the current type
        * are not authenticated.
        * Override this to display a message specific to the type of dev status, e.g.,
        * "Authenticate to see more commits"
        * @returns {String}
        */
        getOAuthMessageInCanvas: function getOAuthMessageInCanvas() {
            return formatter.I18n.getText('devstatus.authentication.authenticate.generic.title');
        },
        /**
        * Returns the message to be displayed in the main canvas of the detailed dialog, when all instances of the current type
        * are not authenticated.
        * Override this to display a message specific to the type of dev status, e.g.,
        * "Unable to retrieve commit information"
        * @returns {String}
        */
        getConnectionMessageInCanvas: function getConnectionMessageInCanvas() {
            return formatter.I18n.getText('devstatus.authentication.connection-problem.generic.title');
        },
        /**
        * Returns the message to be displayed in the main canvas of the detailed dialog, when the user does not have permission
        * to view all dev status even after being authenticated.
        * Override this to display a message specific to the type of dev status, e.g.,
        * "You don't have access to view all related commits. Please contact your administrator."
        * @returns {String}
        */
        getNoPermissionToViewAllMessageInCanvas: function getNoPermissionToViewAllMessageInCanvas() {
            return formatter.I18n.getText('devstatus.authentication.connection-problem.generic.title');
        },
        /**
        * Returns the message to be displayed when there are permission / connection problems.
        *
        * Either a contact administrators message for logged in users, or a log in message otherwise.
        *
        * @returns {String}
        */
        getContactAdmistratorsOrLoginMessageInCanvas: function getContactAdmistratorsOrLoginMessageInCanvas() {
            if (JIRA.Users.LoggedInUser.isAnonymous()) {
                return formatter.I18n.getText('devstatus.authentication.no-permission-to-view-all.generic.login');
            } else {
                return formatter.I18n.getText('devstatus.authentication.no-permission-to-view-all.generic.admin-contact');
            }
        },

        /**
        * Checks whether the detailed data has some data for the given detail dialog.
        * @param detail {Array} The detail json object.
        * @returns {boolean} true if there is some data for the given detail dialog.
        */
        hasData: function hasData(detail) {
            return detail.length > 0;
        },

        /* ============================================================================= */

        show: function show() {
            this.dialog.show();
        },

        hide: function hide() {
            this.dialog.hide();
        },

        _getPane: function _getPane(applicationType) {
            // http://learn.jquery.com/using-jquery-core/faq/how-do-i-select-an-element-by-an-id-that-has-characters-used-in-css-notation/
            return applicationType ? this.$el.find('#tab-content-' + applicationType.replace(/(:|\.|\[|\])/g, '\\$1')) : $();
        },

        /**
        * Get the content container for the given application type (tab).
        * If the applicaitonType is not specified, get the current one.
        */
        getContentContainer: function getContentContainer(applicationType) {
            return this._getPane(applicationType || this._getActiveApplicationType()).find('.detail-content-container');
        },

        _doTabClick: function _doTabClick(e) {
            e.preventDefault();
            var appType = this._getActiveApplicationType();
            detailDialogLocalStorage.setItem(this._getTabStorageId(), appType);
            this.model.switchTab(appType, this.shouldRefreshOnTabSwitch(appType));
            this.analytics && this.analytics.fireDetailTabClicked(appType);
        },

        _redirectToLoginIf401: function _redirectToLoginIf401(xhr) {
            if (xhr && xhr.status === 401) {
                // not logged in or session expired
                // redirect to login page by reloading the page
                devStatusNavigate.redirectToLogin();
                return true;
            }
            return false;
        },

        _initFetchHandlers: function _initFetchHandlers() {
            this.model.on('fetchRequested', this._showLoadingIndicator, this);
            this.model.on('fetchSucceeded', this._handleFetchSucceeded, this);
            this.model.on('fetchFailed', this._handleFetchFailed, this);
        },

        _handleFetchSucceeded: function _handleFetchSucceeded(applicationType, result) {
            this._hideLoadingIndicator(applicationType);
            // If there are any details show them, otherwise there was an error
            var hasData = result.detail && this.hasData(result.detail);
            if (hasData) {
                this.renderSuccess(applicationType, result.detail);
            }
            // always try to render error regardless of whether there are data displayed
            this._renderError(applicationType, result.errors, hasData);
            this._postRender();
        },

        _handleFetchFailed: function _handleFetchFailed(applicationType, xhr) {
            this._hideLoadingIndicator(applicationType);
            if (!this._redirectToLoginIf401(xhr)) {
                this._renderError(applicationType, [], false, true); // indicate ajaxFailed to render as generic connection problem
            }
        },

        _initAuthenticationCallbacks: function _initAuthenticationCallbacks() {
            this._patchAJSIconsForAppLinks();
            // setup handlers for oauth callback (via applinks)
            var instance = this;
            var oauthApprovedHandler = function oauthApprovedHandler(e, applinkProperties) {
                // notify the model about this change so that it could initiate the refresh if needed
                instance.model.oauthStatusChanged(applinkProperties.appType);
                // refresh authentication status by initiating the api call again
                instance.model.fetchAuthenticationStatuses();
                // stop the default applinks handler to reload the window
                e.preventDefault();
            };

            var getProductFromApplinkProperties = function getProductFromApplinkProperties(applinkProperties) {
                var product = null;
                if (applinkProperties.id && applinkProperties.appUri && applinkProperties.appName && applinkProperties.appType) {
                    product = {
                        applicationLinkId: applinkProperties.id,
                        baseUrl: applinkProperties.appUri,
                        name: applinkProperties.appName,
                        type: applinkProperties.appType
                    };
                }
                return product;
            };

            var renderOauthFailureErrorToUser = function renderOauthFailureErrorToUser(applinkProperties, messages) {
                var products = [getProductFromApplinkProperties(applinkProperties)];
                var Helpers = __webpack_require__("./js/util/Helpers.js");
                var sanitisedMessages = Helpers.copyAndMarkStringPropertiesAsSanitised(messages);

                var renderAdminError = function renderAdminError() {
                    if (JIRA.isAdmin()) {
                        instance._renderConnectionError(instance.model._getCurrentApplicationType(), products, {
                            message: sanitisedMessages.adminError,
                            details: sanitisedMessages.adminErrorDetails
                        });
                    } else {
                        instance._renderConnectionError(instance.model._getCurrentApplicationType(), products);
                    }
                };

                var renderUserError = function renderUserError() {
                    instance._renderAuthenticationError(instance.model._getCurrentApplicationType(), products, [], sanitisedMessages.userError);
                };

                if (sanitisedMessages.adminError) {
                    renderAdminError();
                } else if (sanitisedMessages.userError) {
                    renderUserError();
                }
            };

            /**
            * Control is handed to this function when applinks raises an "applinks.auth.denied" event, signalling that
            * some part of the oauth dance for a particular applink has failed.
            *
            * @param e {Object} an object representing the event
            * @param applinkProperties {Object} contains information about the applink involved such as:
            *      'id': the id for the applink
            *      'appUri': the URI for the remote app
            *      'appName': the name of the remote app
            *      'appType': the type of the remote app
            * @param messages {Object} an object containing the following properties
            *       'userError': an error message relevant to a non-admin user
            *       'adminError': an error message relevant to an admin user
            *       'adminErrorDetails': a list of details related to the admin message if there are any
            */
            var oauthFailedHandler = function oauthFailedHandler(e, applinkProperties, messages) {
                if (messages) {
                    renderOauthFailureErrorToUser(applinkProperties, messages);
                }
                // there could be different reasons why the denied event is fired
                // usually it's about some errors or the user explicitly denied
                // We handle one particular case differently:
                // When the user's session expired, we redirect to the login page
                $.ajax(wrmContextPath() + '/rest/auth/1/session').promise().fail(function (xhr) {
                    instance._redirectToLoginIf401(xhr);
                });
            };
            var $document = $(document);
            $document.bind('applinks.auth.approved', oauthApprovedHandler);
            $document.bind('applinks.auth.denied', oauthFailedHandler);

            // clean up the oauth callback upon dialog close
            $(this.dialog).bind('Dialog.beforeHide', function () {
                $document.unbind('applinks.auth.approved', oauthApprovedHandler);
                $document.unbind('applinks.auth.denied', oauthFailedHandler);

                // remove all callbacks on the model.
                instance.model.off(null, null, instance);

                // clean up the inline dialog if it exists
                instance.instanceListPopup && instance.instanceListPopup.remove();
            });

            // create a hidden banner div.applinks-auth-confirmation-container so that the confirmation msg is not shown
            $('<div class="applinks-auth-confirmation-container hidden"></div>').appendTo(this.$el);
        },

        _initFetchAuthenticationHandlers: function _initFetchAuthenticationHandlers() {
            this.model.on('fetchAuthRequested', this._showLoadingIndicator, this);
            this.model.on('fetchAuthSucceeded', this._handleAuthSucceeded, this);
            this.model.on('fetchAuthFailed', this._handleAuthFailed, this);
        },

        _handleAuthSucceeded: function _handleAuthSucceeded(result) {
            var instance = this;
            // get only those that are not authenticated
            var unauthInstances = _.filter(result, function (instanceWithStatus) {
                // only care about those that are not authenticated, and have an application link id
                return instanceWithStatus.configured && !instanceWithStatus.authenticated && instanceWithStatus.source && instanceWithStatus.source.applicationLinkId;
            });
            var statusDiv = this._getOAuthStatusDiv();
            if (unauthInstances.length > 0 && !JIRA.Users.LoggedInUser.isAnonymous()) {
                statusDiv.html(this.oauthStatusTemplate({
                    message: this.getOAuthMessageInFooter(unauthInstances)
                }));
                this._renderUnauthInstancesInFooter(unauthInstances);
                statusDiv.show();
            } else {
                statusDiv.hide();
            }
        },

        _handleAuthFailed: function _handleAuthFailed(xhr) {
            this._redirectToLoginIf401(xhr);
            // silently ignore this error
            this._getOAuthStatusDiv().hide();
        },

        _renderUnauthInstancesInFooter: function _renderUnauthInstancesInFooter(unauthInstances) {
            var statusDiv = this._getOAuthStatusDiv();
            var appLinkDivs = _.map(_.pluck(unauthInstances, 'source'), this._createOAuthInstanceDiv);
            if (appLinkDivs.length > 0) {
                statusDiv.append(appLinkDivs[0]);
                if (appLinkDivs.length > 1) {
                    statusDiv.append(', ');
                    statusDiv.append(appLinkDivs[1]);
                    if (appLinkDivs.length > 2) {
                        statusDiv.append(' ');
                        // show more link
                        var moreLink = $('<span class="more-instances"><a href="#">' + formatter.I18n.getText('devstatus.authentication.message.more.link') + '</a></span>');
                        statusDiv.append(moreLink);
                        var inlineDialogContent = $('<ul class="instance-list"></ul>');
                        _.each(appLinkDivs.slice(2), function (appLinkDiv) {
                            inlineDialogContent.append($('<li class="instance-in-popup"></li>').append(appLinkDiv));
                        });
                        AJS.InlineDialog(moreLink, 'instance-list-popup', function (content, trigger, showPopup) {
                            content.html(inlineDialogContent);
                            showPopup();
                            return false;
                        }, {
                            width: 150,
                            offsetX: -100,
                            onTop: true
                        });
                    }
                }
            }
        },

        _createOAuthInstanceDiv: function _createOAuthInstanceDiv(instance) {
            var div = ApplinksUtils.createAuthRequestInline(null, {
                id: instance.applicationLinkId,
                authUri: wrmContextPath() + '/plugins/servlet/applinks/oauth/login-dance/authorize?applicationLinkID=' + encodeURIComponent(instance.applicationLinkId),
                appUri: instance.baseUrl,
                appName: instance.name,
                appType: instance.type
            });
            return $('<span class="instance"></span>').append(div.find('a.applink-authenticate').text(instance.name));
        },

        /**
        * Not needed once APL-1106 is done and included in jira core
        * @private
        */
        _patchAJSIconsForAppLinks: function _patchAJSIconsForAppLinks() {
            AJS.icons = AJS.icons || {};
            AJS.icons.addIcon = AJS.icons.addIcon || {};
            AJS.icons.addIcon.init = AJS.icons.addIcon.init || function () {};
        },

        _getOAuthStatusDiv: function _getOAuthStatusDiv() {
            var oauthStatusDiv = this.$el.find('.buttons-container .oauth-status');
            if (oauthStatusDiv.length) {
                return oauthStatusDiv;
            } else {
                // create it if it's not there
                // insert it after the buttons, since it's not easy to make it left aligned if inserted before the buttons
                return $('<div class="oauth-status" />').appendTo(this.$el.find('.buttons-container.form-footer'));
            }
        },

        _renderError: function _renderError(applicationType, errors, hasData, ajaxFailed) {
            /**
            * split the errors into groups. Currently this includes: 'unauthorized', 'incapable' and others
            */
            var groups = _.groupBy(errors, function (errorInstance) {
                var errorType = errorInstance.error;
                if (errorType === 'unauthorized' || errorType === 'incapable') {
                    return errorType;
                } else {
                    return 'others';
                }
            });

            /**
            * Plucking the relevant error type from the groups to show in the UI
            * Currently we only show errors for unauthorized and others.
            * Incapable errors are not shown in the detail dialog.
            */
            var unauth = _.pluck(groups['unauthorized'], 'instance');
            var others = _.pluck(groups['others'], 'instance');

            if (unauth.length > 0) {
                // trigger a refresh of the authentication message in the footer
                this.model.fetchAuthenticationStatuses();
            }
            if (hasData) {
                if (others.length > 0) {
                    // prepend warning if there's any connection error
                    this._renderConnectionErrorBeforeData(applicationType, others);
                }
            } else {
                // we would take over the whole screen to display error, unless hasData
                if (unauth.length > 0) {
                    this._renderAuthenticationError(applicationType, unauth, others);
                } else {
                    if (ajaxFailed || others.length > 0) {
                        // render the connection problem screen only when hasData is false
                        this._renderConnectionError(applicationType, others);
                    } else {
                        // if not ajaxFailed and not errors at all, there must be some data that the user is not allowed to see
                        this._renderNoPermissionToViewAllWarning(applicationType);
                    }
                }
            }
        },

        _renderConnectionErrorBeforeData: function _renderConnectionErrorBeforeData(applicationType, otherInstances) {
            this.getContentContainer(applicationType).prepend(this.connectionProblemWarningTemplate({
                instances: otherInstances,
                showContactAdminForm: this.options.showContactAdminForm
            }));
        },

        _renderConnectionError: function _renderConnectionError(applicationType, otherInstances, adminError) {
            this.getContentContainer(applicationType).html(this.connectionProblemTemplate({
                instances: otherInstances,
                adminError: adminError,
                showContactAdminForm: this.options.showContactAdminForm,
                title: this.getConnectionMessageInCanvas()
            }));
        },

        /**
        * Render the no permission to view all warning if necessary.
        * @param applicationType the current application type
        * @param totalItemRendered the total number of data rendered on the canvas, e.g., total number of commits.
        */
        renderNoPermissionToViewAllWarningAtBottom: function renderNoPermissionToViewAllWarningAtBottom(applicationType, totalItemRendered) {
            var tab = this.model.get('tabs')[applicationType] || {};
            var content = this.model.get('contentMap')[applicationType] || {};

            if (totalItemRendered < tab.count) {
                if ((content.errors || []).length === 0 || JIRA.Users.LoggedInUser.isAnonymous()) {
                    // if no errors and total number of data is smaller than the count from summary
                    //  then we show the warning that the user might not have permission to see all data
                    // OR
                    // if the user is anonymous, we will show a login message
                    this.getContentContainer(applicationType).append(this._getNoPermissionToViewAllHtml());
                }
            }
        },

        _getNoPermissionToViewAllHtml: function _getNoPermissionToViewAllHtml() {
            return this.noPermissionToViewAllTemplate({
                message: this.getNoPermissionToViewAllMessageInCanvas(),
                secondaryMessage: this.getContactAdmistratorsOrLoginMessageInCanvas()
            });
        },

        _renderNoPermissionToViewAllWarning: function _renderNoPermissionToViewAllWarning(applicationType) {
            this.getContentContainer(applicationType).html(this._getNoPermissionToViewAllHtml());
        },

        _renderAuthenticationError: function _renderAuthenticationError(applicationType, unauthInstances, otherInstances, userError) {
            var container = this.getContentContainer(applicationType);
            container.html(this.authenticationTemplate({
                unauthInstances: unauthInstances,
                title: this.getOAuthMessageInCanvas(),
                otherInstances: otherInstances,
                showContactAdminForm: this.options.showContactAdminForm,
                userError: userError
            }));
            var appLinkDivs = _.map(unauthInstances, this._createOAuthInstanceDiv);
            var instancesDiv = container.find('.instances');
            _.each(appLinkDivs, function (appLinkDiv, index) {
                if (index !== 0) {
                    // add comma as separator if not the first one
                    instancesDiv.append(', ');
                }
                instancesDiv.append(appLinkDiv);
            });
        },

        _initFormDialog: function _initFormDialog() {
            var instance = this;
            this.dialog = new FormDialog({
                id: this.options.id,
                width: this.options.width,
                content: function content(ready) {
                    instance.setElement(this.$popup);
                    instance.delegateEvents(_.extend({}, instance.frameEvents, instance.events));

                    instance._renderFrame();

                    instance._initAuthenticationCallbacks();
                    instance._initFetchAuthenticationHandlers();
                    instance.model.fetchAuthenticationStatuses();

                    var targetTab = detailDialogLocalStorage.getItem(instance._getTabStorageId());
                    if (instance._tabHasContent(targetTab)) {
                        instance._activateTab(targetTab);
                    }
                    instance.model.switchTab(instance._getActiveApplicationType());

                    ready();
                },
                autoClose: true
            });
        },

        _postRender: function _postRender() {
            this.$el.find('.extra-content-in-title').tooltip();
            this.dialog._positionInCenter();
            // Select the first link element in the active tab
            this.$el.find('.active-pane a:eq(0)').focus();
        },

        _getActiveApplicationType: function _getActiveApplicationType() {
            return this.$el.find('.menu-item.active-tab').data('applicationType');
        },

        _getStorageRef: function _getStorageRef() {
            var projectKey = this.options.issueKey.split('-')[0];
            return projectKey + '-' + this.options.type;
        },

        _getTabStorageId: function _getTabStorageId() {
            return 'stored-tab-' + this._getStorageRef();
        },

        _tabHasContent: function _tabHasContent(tab) {
            return this.$el.find('#tab-menu-' + tab).length > 0;
        },

        _activateTab: function _activateTab(tab) {
            // Deactivate the default tab and content pane first
            this.$el.find('.menu-item.active-tab').toggleClass('active-tab');
            this.$el.find('.tabs-pane.active-pane').toggleClass('active-pane');

            this.$el.find('#tab-menu-' + tab).toggleClass('active-tab');
            this.$el.find('#tab-content-' + tab).toggleClass('active-pane');
        },

        _showLoadingIndicator: function _showLoadingIndicator(applicationType) {
            var targetPane = this._getPane(applicationType);
            targetPane._removeClass('ready');
            targetPane.addClass('loading');
            var loadingIndicator = targetPane.find('.status-loading');
            loadingIndicator.spin('large');
            loadingIndicator.show();
        },

        _hideLoadingIndicator: function _hideLoadingIndicator(applicationType) {
            var targetPane = this._getPane(applicationType);
            targetPane.addClass('ready');
            var loadingIndicator = targetPane.find('.status-loading');
            if (loadingIndicator) {
                targetPane.removeClass('loading');
                loadingIndicator.hide();
                loadingIndicator.spinStop();
            }
        },

        _renderFrame: function _renderFrame() {
            this.$el.html(this.frameTemplate({
                title: this.getTitle(this.options.count, this.options.issueKey),
                tabs: this._convertTabsForSoy(),
                initialTab: this.options.initialTab
            }));

            if (this.options.height) {
                this.$el.find('.form-body').css('min-height', this.options.height);
            }
        },

        _convertTabsForSoy: function _convertTabsForSoy() {
            /*
            Tabs given by model is in the form of:
            {
            "application": {
            count: number
            }
            }
            This is to convert the above map into an array so foreach in soy works
            */
            return _.chain(this.model.get('tabs')).map(function (data, name) {
                return _.extend({
                    type: name
                }, data);
            }).sortBy(function (data) {
                return data.type;
            }).value();
        },

        /**
        * Sorts a list of review overviews putting the ones with the more important states before the ones with the less important states, and filtering unknown states
        */
        _sortReviewsByStatus: function _sortReviewsByStatus(reviewOverviews) {
            var reviewPriorities = ['REVIEW', 'APPROVAL', 'SUMMARIZE', 'REJECTED', 'CLOSED'];
            return _.chain(reviewOverviews).filter(function (review) {
                return _.contains(reviewPriorities, review.state);
            }).sortBy(function (review) {
                return _.indexOf(reviewPriorities, review.state);
            }).value();
        },

        _setupReviewsPopup: function _setupReviewsPopup(e, dataFunction, onShowFunction, onSelectFunction) {
            e.preventDefault();

            var target = $(e.currentTarget);
            if (!target.data('inline-dialog-inited')) {
                var id = 'commit-reviews-popup-' + this._tooltipSeq++;
                this.activeReviewsToolTip = AJS.InlineDialog(target, id, function (content, trigger, showPopup) {
                    var reviewData = dataFunction($(trigger));
                    onShowFunction && onShowFunction();
                    content.html(JIRA.Templates.DevStatus.DetailDialog.reviewsInlineDialog({
                        reviewData: reviewData
                    }));

                    if (onSelectFunction) {
                        content.find('a').click(onSelectFunction);
                    }

                    showPopup();
                }, {
                    cacheContent: false,
                    hideDelay: 200,
                    showDelay: 50,
                    onHover: true,
                    width: false //Stop AUI from hardcoding inline dialog width
                });

                target.data('inline-dialog-inited', true).mouseenter();
            }
        },

        _removeInlineDialog: function _removeInlineDialog(inlineDialog) {
            if (this[inlineDialog]) {
                this[inlineDialog].hide();
                this[inlineDialog].remove();
                this[inlineDialog] = undefined;
            }
        }
    });
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ "./js/viewissue/dialog/build/DetailDialogBuildView.js":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

__webpack_require__(12);
__webpack_require__(18);

// @formatter:off
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__("jira.webresources:jira-formatter/require('jira/util/formatter')"), __webpack_require__("jira.webresources:ajs-underscorejs-amd-shim/require('underscore')"), __webpack_require__("./js/viewissue/dialog/BaseDetailDialogView.js"), __webpack_require__], __WEBPACK_AMD_DEFINE_RESULT__ = function (formatter, _, BaseDetailDialogView, require) {
    var devStatusDate = __webpack_require__("./js/util/DateUtils.js");
    var devAnalytics = __webpack_require__("./js/analytics/devstatus-analytics.js");

    return BaseDetailDialogView.extend({
        template: JIRA.Templates.DevStatus.DetailDialog.build,

        events: {
            'click a.project-link': '_onClickProjectLink',
            'click a.plan-link': '_onClickPlanLink',
            'click a.build-link': '_onClickBuildLink'
        },

        initialize: function initialize(options) {
            this.analytics = devAnalytics.BuildsAnalytics;
            BaseDetailDialogView.prototype.initialize.call(this, _.extend({
                type: 'build',
                width: 1000,
                height: 400
            }, options));
        },

        renderSuccess: function renderSuccess(applicationType, result) {
            var projects = _.reduce(result, function (memo, data) {
                return memo.concat(data.projects || []);
            }, []);
            var container = this.getContentContainer(applicationType);
            container.html(this.template({
                applicationType: applicationType,
                projects: this.sortProjectsAndPlans(projects),
                hasArtifacts: this.hasArtifacts(projects)
            }));
            this.renderNoPermissionToViewAllWarningAtBottom(applicationType, this.getBuildCount(projects));
            devStatusDate.addTooltip(container);
            return this;
        },

        getTitle: function getTitle(count, issue) {
            return formatter.I18n.getText('devstatus.detail.panel.title.build', count, issue);
        },

        getOAuthMessageInFooter: function getOAuthMessageInFooter(instances) {
            return formatter.I18n.getText('devstatus.authentication.message.build', instances.length);
        },

        getOAuthMessageInCanvas: function getOAuthMessageInCanvas() {
            return formatter.I18n.getText('devstatus.authentication.authenticate.build.title');
        },

        getConnectionMessageInCanvas: function getConnectionMessageInCanvas() {
            return formatter.I18n.getText('devstatus.authentication.connection-problem.build.title');
        },

        getNoPermissionToViewAllMessageInCanvas: function getNoPermissionToViewAllMessageInCanvas() {
            return formatter.I18n.getText('devstatus.authentication.no-permission-to-view-all.build.title');
        },

        hasData: function hasData(detail) {
            return _.reduce(detail, function (memo, data) {
                return memo.concat(data.projects || []);
            }, []).length > 0;
        },

        /**
        * Sort projects by most recent build first and plans from newest to oldest build.
        */
        sortProjectsAndPlans: function sortProjectsAndPlans(projects) {
            projects = _.sortBy(projects, function (project) {
                return _.last(_.sortBy(project.plans, function (plan) {
                    return plan.build.finishedDate;
                })).build.finishedDate;
            }).reverse();
            _.each(projects, function (project) {
                // Dates should _always_ be in ISO format - so ASCII sorting will work
                project.plans = _.sortBy(project.plans, function (plan) {
                    return plan.build.finishedDate;
                }).reverse();
            });
            return projects;
        },

        hasArtifacts: function hasArtifacts(projects) {
            return _.any(projects, function (project) {
                return _.any(project.plans, function (plan) {
                    return plan.build && plan.build.artifacts && plan.build.artifacts.length;
                });
            });
        },

        /**
        * Calculate the total number of builds in all projects.
        */
        getBuildCount: function getBuildCount(projects) {
            return _.union.apply(null, _.map(projects, function (project) {
                // project's plan
                return _.pluck(project.plans, 'key');
            })).length;
        },

        _onClickProjectLink: function _onClickProjectLink() {
            devAnalytics.BuildsAnalytics.fireDetailProjectClicked();
        },

        _onClickPlanLink: function _onClickPlanLink() {
            devAnalytics.BuildsAnalytics.fireDetailPlanClicked();
        },

        _onClickBuildLink: function _onClickBuildLink() {
            devAnalytics.BuildsAnalytics.fireDetailBuildClicked();
        }
    });
}.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));

/***/ }),

/***/ 12:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 14:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 15:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 18:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 2:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ }),

/***/ 3:
/***/ (function(module, exports) {

module.exports = undefined;

/***/ })

});
//# sourceMappingURL=12.b774db5e64988590d35c.js.map