// node_modules/skatejs/lib/fix-ie-innerhtml.js
(typeof window === 'undefined' ? global : window).__5551fa8e4adda8d20d1c375c56d1ec4a = (function () {
  var module = {
    exports: {}
  };
  var exports = module.exports;
  var defineDependencies = {
    "module": module,
    "exports": exports
  };
  var define = function defineReplacementWrapper(generatedModuleName) {
    return function defineReplacement(name, deps, func) {
      var root = (typeof window === 'undefined' ? global : window);
      var defineGlobal = root.define;
      var rval;
      var type;
  
      func = [func, deps, name].filter(function (cur) {
        return typeof cur === 'function';
      })[0];
      deps = [deps, name, []].filter(Array.isArray)[0];
      rval = func.apply(null, deps.map(function (value) {
        return defineDependencies[value];
      }));
      type = typeof rval;
  
      // Support existing AMD libs.
      if (typeof defineGlobal === 'function') {
        // Almond always expects a name so resolve one (#29).
        defineGlobal(typeof name === 'string' ? name : generatedModuleName, deps, func);
      }
  
      // Some processors like Babel don't check to make sure that the module value
      // is not a primitive before calling Object.defineProperty() on it. We ensure
      // it is an instance so that it can.
      if (type === 'string') {
        rval = String(rval);
      } else if (type === 'number') {
        rval = Number(rval);
      } else if (type === 'boolean') {
        rval = Boolean(rval);
      }
  
      // Reset the exports to the defined module. This is how we convert AMD to
      // CommonJS and ensures both can either co-exist, or be used separately. We
      // only set it if it is not defined because there is no object representation
      // of undefined, thus calling Object.defineProperty() on it would fail.
      if (rval !== undefined) {
        exports = module.exports = rval;
      }
    };
  }("__5551fa8e4adda8d20d1c375c56d1ec4a");
  define.amd = true;
  
  (function (factory) {
    if (typeof define === "function" && define.amd) {
      define(["exports"], factory);
    } else if (typeof exports !== "undefined") {
      factory(exports);
    }
  })(function (exports) {
  
    var isIeUntil10 = /MSIE/.test(navigator.userAgent);
    var isIe11 = /Trident/.test(navigator.userAgent);
    var isIe = isIeUntil10 || isIe11;
    var elementPrototype = window.HTMLElement.prototype;
  
    // ! This walkTree method differs from the implementation in ../../utils/walk-tree
    // It invokes the callback only for the children, not the passed node and the second parameter to the callback is the parent node
    function walkTree(node, cb) {
      var childNodes = node.childNodes;
  
      if (!childNodes) {
        return;
      }
  
      var childNodesLen = childNodes.length;
  
      for (var a = 0; a < childNodesLen; a++) {
        var childNode = childNodes[a];
        cb(childNode, node);
        walkTree(childNode, cb);
      }
    }
  
    function fixInnerHTML() {
      var originalInnerHTML = Object.getOwnPropertyDescriptor(elementPrototype, "innerHTML");
  
      var get = function get() {
        return originalInnerHTML.get.call(this);
      };
      get._hasBeenEnhanced = true;
  
      // This redefines the innerHTML property so that we can ensure that events
      // are properly triggered.
      Object.defineProperty(elementPrototype, "innerHTML", {
        get: get,
        set: function set(html) {
          walkTree(this, function (node, parentNode) {
            var mutationEvent = document.createEvent("MutationEvent");
            mutationEvent.initMutationEvent("DOMNodeRemoved", true, false, parentNode, null, null, null, null);
            node.dispatchEvent(mutationEvent);
          });
          originalInnerHTML.set.call(this, html);
        }
      });
    }
  
    if (isIe) {
      // IE 9-11
      var propertyDescriptor = Object.getOwnPropertyDescriptor(elementPrototype, "innerHTML");
      var hasBeenEnhanced = !!propertyDescriptor && propertyDescriptor.get._hasBeenEnhanced;
  
      if (!hasBeenEnhanced) {
        if (isIe11) {
          // IE11's native MutationObserver needs some help as well :()
          window.MutationObserver = window.JsMutationObserver || window.MutationObserver;
        }
  
        fixInnerHTML();
      }
    }
  });
  
  return module.exports;
}).call(this);