// node_modules/@atlassian/aui/src/js/aui/toggle.js
(typeof window === 'undefined' ? global : window).__be71d4c22d5f8ec8e24cf5cbfc949106 = (function () {
  var module = {
    exports: {}
  };
  var exports = module.exports;
  
  'use strict';
  
  __e0a09f3ee5af5c6a891a000b0e664556;
  
  __65bf2e9d62756879a7805c63dea11935;
  
  var _attributes = __82e760f4580e37eda172e78ba0378f6d;
  
  var _jquery = __02fa0d2334b5d2f9701871403ba9d89a;
  
  var _jquery2 = _interopRequireDefault(_jquery);
  
  var _enforcer = __da99b881b3bdaf63767de8d2780ca44c;
  
  var _enforcer2 = _interopRequireDefault(_enforcer);
  
  var _keyCode = __d92d89c196b4703777e79d25a9f94b7f;
  
  var _keyCode2 = _interopRequireDefault(_keyCode);
  
  var _skatejsTemplateHtml = __19c740e7a69d815ecec16b8dd69f0e00;
  
  var _skatejsTemplateHtml2 = _interopRequireDefault(_skatejsTemplateHtml);
  
  var _skate = __da172e72afc5a7088e3034df761062a6;
  
  var _skate2 = _interopRequireDefault(_skate);
  
  var _constants = __b2cfc977d45980ce4c29f90ea86d5180;
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
  
  function getInput(element) {
      return element._input || (element._input = element.querySelector('input'));
  }
  
  function removedAttributeHandler(attributeName, element) {
      getInput(element).removeAttribute(attributeName);
  }
  
  function fallbackAttributeHandler(attributeName, element, change) {
      getInput(element).setAttribute(attributeName, change.newValue);
  }
  
  function getAttributeHandler(attributeName) {
      return {
          removed: removedAttributeHandler.bind(this, attributeName),
          fallback: fallbackAttributeHandler.bind(this, attributeName)
      };
  }
  
  var formAttributeHandler = {
      removed: function removed(element) {
          removedAttributeHandler.call(this, 'form', element);
          element._formId = null;
      },
      fallback: function fallback(element, change) {
          fallbackAttributeHandler.call(this, 'form', element, change);
          element._formId = change.newValue;
      }
  };
  
  var idAttributeHandler = {
      removed: removedAttributeHandler.bind(undefined, 'id'),
      fallback: function fallback(element, change) {
          getInput(element).setAttribute('id', '' + change.newValue + _constants.INPUT_SUFFIX);
      }
  };
  
  var checkedAttributeHandler = {
      removed: function removed(element) {
          removedAttributeHandler.call(this, 'checked', element);
          getInput(element).checked = false;
      },
      fallback: function fallback(element, change) {
          fallbackAttributeHandler.call(this, 'checked', element, change);
          getInput(element).checked = true;
      }
  };
  
  var labelHandler = {
      removed: function removed(element) {
          getInput(element).removeAttribute('aria-label');
      },
      fallback: function fallback(element, change) {
          getInput(element).setAttribute('aria-label', change.newValue);
      }
  };
  
  function clickHandler(element, e) {
      if (!element.disabled && !element.busy && e.target !== element._input) {
          element._input.click();
      }
      (0, _attributes.setBooleanAttribute)(element, 'checked', getInput(element).checked);
  }
  
  function setDisabledForLabels(element, disabled) {
      if (!element.id) {
          return;
      }
      Array.prototype.forEach.call(document.querySelectorAll('aui-label[for="' + element.id + '"]'), function (el) {
          el.disabled = disabled;
      });
  }
  
  /**
   * Workaround to prevent pressing SPACE on busy state.
   * Preventing click event still makes the toggle flip and revert back.
   * So on CSS side, the input has "pointer-events: none" on busy state.
   */
  function bindEventsToInput(element) {
      element._input.addEventListener('keydown', function (e) {
          if (element.busy && e.keyCode === _keyCode2.default.SPACE) {
              e.preventDefault();
          }
      });
      // prevent toggle can be trigger through SPACE key on Firefox
      if (navigator.userAgent.toLowerCase().indexOf('firefox') > -1) {
          element._input.addEventListener('click', function (e) {
              if (element.busy) {
                  e.preventDefault();
              }
          });
      }
  }
  
  (0, _skate2.default)('aui-toggle', {
      template: (0, _skatejsTemplateHtml2.default)('<input type="checkbox" class="aui-toggle-input">', '<span class="aui-toggle-view">', '<span class="aui-toggle-tick aui-icon aui-icon-small aui-iconfont-success"></span>', '<span class="aui-toggle-cross aui-icon aui-icon-small aui-iconfont-close-dialog"></span>', '</span>'),
      created: function created(element) {
          element._input = getInput(element); // avoid using _input in attribute handlers
          element._tick = element.querySelector('.aui-toggle-tick');
          element._cross = element.querySelector('.aui-toggle-cross');
  
          (0, _jquery2.default)(element._input).tooltip({
              title: function title() {
                  return this.checked ? this.getAttribute('tooltip-on') : this.getAttribute('tooltip-off');
              },
              gravity: 's',
              hoverable: false
          });
          bindEventsToInput(element);
      },
      attached: function attached(element) {
          (0, _enforcer2.default)(element).attributeExists('label');
      },
      events: {
          click: clickHandler
      },
      attributes: {
          id: idAttributeHandler,
          checked: checkedAttributeHandler,
          disabled: getAttributeHandler('disabled'),
          form: formAttributeHandler,
          name: getAttributeHandler('name'),
          value: getAttributeHandler('value'),
          'tooltip-on': {
              value: AJS.I18n.getText('aui.toggle.on'),
              fallback: function fallback(element, change) {
                  getInput(element).setAttribute('tooltip-on', change.newValue || AJS.I18n.getText('aui.toggle.on'));
              }
          },
          'tooltip-off': {
              value: AJS.I18n.getText('aui.toggle.off'),
              fallback: function fallback(element, change) {
                  getInput(element).setAttribute('tooltip-off', change.newValue || AJS.I18n.getText('aui.toggle.off'));
              }
          },
          label: labelHandler
      },
      prototype: {
          focus: function focus() {
              this._input.focus();
              return this;
          },
          get checked() {
              return this._input.checked;
          },
          set checked(value) {
              // Need to explicitly set the property on the checkbox because the
              // checkbox's property doesn't change with it's attribute after it
              // is clicked.
              this._input.checked = value;
              return (0, _attributes.setBooleanAttribute)(this, 'checked', value);
          },
          get disabled() {
              return this._input.disabled;
          },
          set disabled(value) {
              return (0, _attributes.setBooleanAttribute)(this, 'disabled', value);
          },
          get form() {
              return document.getElementById(this._formId);
          },
          set form(value) {
              formAttributeHandler.fallback.call(this, this, { newValue: value || null });
              return this.form;
          },
          get name() {
              return this._input.name;
          },
          set name(value) {
              this.setAttribute('name', value);
              return value;
          },
          get value() {
              return this._input.value;
          },
          set value(value) {
              // Setting the value of an input to null sets it to empty string.
              this.setAttribute('value', value === null ? '' : value);
              return value;
          },
          get busy() {
              return this._input.getAttribute('aria-busy') === 'true';
          },
          set busy(value) {
              (0, _attributes.setBooleanAttribute)(this, 'busy', value);
              if (value) {
                  this._input.setAttribute('aria-busy', 'true');
                  this._input.indeterminate = true;
                  if (this.checked) {
                      (0, _jquery2.default)(this._input).addClass('indeterminate-checked');
                      (0, _jquery2.default)(this._tick).spin({ zIndex: null });
                  } else {
                      (0, _jquery2.default)(this._cross).spin({ zIndex: null, color: 'black' });
                  }
              } else {
                  (0, _jquery2.default)(this._input).removeClass('indeterminate-checked');
                  this._input.indeterminate = false;
                  this._input.removeAttribute('aria-busy');
                  (0, _jquery2.default)(this._cross).spinStop();
                  (0, _jquery2.default)(this._tick).spinStop();
              }
              setDisabledForLabels(this, !!value);
              return value;
          }
      }
  });
  
  return module.exports;
}).call(this);