// node_modules/@atlassian/aui/src/js/aui/button.js
(typeof window === 'undefined' ? global : window).__ba22a6a0f9889bb04a6764c4bc4865a0 = (function () {
  var module = {
    exports: {}
  };
  var exports = module.exports;
  
  'use strict';
  
  var _jquery = __02fa0d2334b5d2f9701871403ba9d89a;
  
  var _jquery2 = _interopRequireDefault(_jquery);
  
  var _log = __8139e9a1368a0224fc430963d21930c8;
  
  var logger = _interopRequireWildcard(_log);
  
  var _amdify = __8f23956215d754ca94df621efa6b0438;
  
  var _amdify2 = _interopRequireDefault(_amdify);
  
  var _skate = __da172e72afc5a7088e3034df761062a6;
  
  var _skate2 = _interopRequireDefault(_skate);
  
  function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
  
  function _isBusy(button) {
      return button.hasAttribute('aria-busy') && button.getAttribute('aria-busy') === 'true';
  }
  
  function isInputNode(button) {
      return button.nodeName === 'INPUT';
  }
  
  (0, _skate2.default)('aui-button', {
      type: _skate2.default.type.CLASSNAME,
      prototype: {
          /**
           * Adds a spinner to the button and hides the text
           *
           * @returns {HTMLElement}
           */
          busy: function busy() {
              if (isInputNode(this) || _isBusy(this)) {
                  logger.warn('It is not valid to call busy() on an input button.');
                  return this;
              }
  
              (0, _jquery2.default)(this).spin();
              this.setAttribute('aria-busy', true);
              this.setAttribute('busy', '');
  
              return this;
          },
  
          /**
           * Removes the spinner and shows the tick on the button
           *
           * @returns {HTMLElement}
           */
          idle: function idle() {
              if (isInputNode(this) || !_isBusy(this)) {
                  logger.warn('It is not valid to call idle() on an input button.');
                  return this;
              }
  
              (0, _jquery2.default)(this).spinStop();
              this.removeAttribute('aria-busy');
              this.removeAttribute('busy');
  
              return this;
          },
  
          /**
           * Removes the spinner and shows the tick on the button
           *
           * @returns {Boolean}
           */
          isBusy: function isBusy() {
              if (isInputNode(this)) {
                  logger.warn('It is not valid to call isBusy() on an input button.');
                  return false;
              }
  
              return _isBusy(this);
          }
      }
  });
  
  (0, _amdify2.default)('aui/button');
  
  return module.exports;
}).call(this);