// node_modules/@atlassian/aui/src/js/aui/blanket.js
(typeof window === 'undefined' ? global : window).__dec7139bfb210c49a7a16fe32dc7bd56 = (function () {
  var module = {
    exports: {}
  };
  var exports = module.exports;
  
  'use strict';
  
  Object.defineProperty(exports, "__esModule", {
      value: true
  });
  exports.undim = exports.dim = undefined;
  
  var _jquery = __02fa0d2334b5d2f9701871403ba9d89a;
  
  var _jquery2 = _interopRequireDefault(_jquery);
  
  var _deprecation = __9ea35e3451360b72ebe8cb8006239936;
  
  var _animation = __1e5eff515fb8ea62ccd80d65455e88cd;
  
  var _globalize = __fb27ffae84b96c14bf339e62cefcf116;
  
  var _globalize2 = _interopRequireDefault(_globalize);
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
  
  var overflowEl;
  var _hiddenByAui = [];
  
  /**
   * Dims the screen using a blanket div
   * @param useShim deprecated, it is calculated by dim() now
   */
  function dim(useShim, zIndex) {
  
      //if we're blanketing the page it means we want to hide the whatever is under the blanket from the screen readers as well
      function hasAriaHidden(element) {
          return element.getAttribute('aria-hidden') ? true : false;
      }
  
      function isAuiLayer(element) {
          return element.className.match(/\baui-layer\b/) ? true : false;
      }
  
      Array.prototype.forEach.call(document.body.children, function (element) {
          if (!hasAriaHidden(element) && !isAuiLayer(element)) {
              element.setAttribute('aria-hidden', 'true');
              _hiddenByAui.push(element);
          }
      });
  
      if (!overflowEl) {
          overflowEl = document.body;
      }
  
      if (useShim === true) {
          useShimDeprecationLogger();
      }
  
      var isBlanketShowing = !!dim.$dim && dim.$dim.attr('aria-hidden') === 'false';
  
      if (!!dim.$dim) {
          dim.$dim.remove();
          dim.$dim = null;
      }
  
      dim.$dim = (0, _jquery2.default)('<div></div>').addClass('aui-blanket');
      dim.$dim.attr('tabindex', '0'); //required, or the last element's focusout event will go to the browser
      dim.$dim.appendTo(document.body);
  
      if (!isBlanketShowing) {
          //recompute after insertion and before setting aria-hidden=false to ensure we calculate a difference in
          //computed styles
          (0, _animation.recomputeStyle)(dim.$dim);
  
          dim.cachedOverflow = {
              overflow: overflowEl.style.overflow,
              overflowX: overflowEl.style.overflowX,
              overflowY: overflowEl.style.overflowY
          };
  
          overflowEl.style.overflowX = 'hidden';
          overflowEl.style.overflowY = 'hidden';
          overflowEl.style.overflow = 'hidden';
      }
  
      dim.$dim.attr('aria-hidden', 'false');
  
      if (zIndex) {
          dim.$dim.css({ zIndex: zIndex });
      }
  
      return dim.$dim;
  }
  
  /**
   * Removes semitransparent DIV
   * @see dim
   */
  function undim() {
      _hiddenByAui.forEach(function (element) {
          element.removeAttribute('aria-hidden');
      });
  
      _hiddenByAui = [];
  
      if (dim.$dim) {
          dim.$dim.attr('aria-hidden', 'true');
  
          if (overflowEl) {
              overflowEl.style.overflow = dim.cachedOverflow.overflow;
              overflowEl.style.overflowX = dim.cachedOverflow.overflowX;
              overflowEl.style.overflowY = dim.cachedOverflow.overflowY;
          }
      }
  }
  
  var useShimDeprecationLogger = (0, _deprecation.getMessageLogger)('useShim', {
      extraInfo: 'useShim has no alternative as it is now calculated by dim().'
  });
  
  (0, _globalize2.default)('dim', dim);
  (0, _globalize2.default)('undim', undim);
  
  exports.dim = dim;
  exports.undim = undim;
  
  return module.exports;
}).call(this);