define('jira-help-tips/page/initialiser', ['jira-help-tips/feature/help-tip-manager', 'jira/util/users/logged-in-user', 'underscore'], function (Manager, LoggedInUser, _) {
    "use strict";

    function initialiseHelpTips() {
        // Check if the user is logged in, otherwise the REST resource will return a status of 401 (Unauthorized)
        if (!LoggedInUser.isAnonymous()) {
            // Load up the user's dismissed tips.
            Manager.fetch();
        }
    }

    return {
        init: _.once(initialiseHelpTips)
    };
});