var _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};AJS.test.require(["com.atlassian.plugins.helptips.jira-help-tips:help-tip"],function(){"use strict";var e=require("jquery"),t=require("underscore"),s=require("jira/jquery/deferred"),i=require("jira-help-tips/feature/help-tip-manager"),n=require("jira-help-tips/feature/help-tip");module("jira-help-tips/feature/help-tip"),test("can create new tips",function(){var e=new n;equal(void 0===e?"undefined":_typeof(e),"object","should be an object")}),test("get a unique client id (cid)",function(){for(var t=[],s=0;s<20;s++)t.push((new n).cid);equal(e.unique(t).length,t.length,"should be as many unique ids as tips created")}),test("can be programmatically dismissed",function(){var e=new n({body:"whee"});ok(!e.isDismissed(),"has not been dismissed yet"),e.dismiss(),ok(e.isDismissed(),"should be dismissed")}),test("can bind dismissal of tip to other elements",function(){var t=new n({body:"whee"}),s=e("<a>click me to dismiss</a>");s.click(function(){t.dismiss()}),s.trigger("click"),ok(t.isDismissed(),"should be dismissed after clicking the anchor link")}),test("tips with the same id have a linked dismissed value",function(){this.sandbox.stub(i,"sync");var e=new n({id:"testtip",body:"firsttip"}),t=new n({id:"testtip",body:"secondtip"});e.dismiss(),ok(t.isDismissed(),"tip2 is considered dismissed because tip1 was.")}),test("tips with no id are considered different",function(){var e=new n({body:"firsttip"}),t=new n({body:"secondtip"});e.dismiss(),ok(!t.isDismissed(),"tip2 is different to tip1 as neither have the same id.")}),module("anchored tip",{setup:function(){e.fx.off=!0,this.context=AJS.test.mockableModuleContext(),this.sandbox=sinon.sandbox.create({useFakeTimers:!0,useFakeServer:!0}),this.clock=this.sandbox.clock,this.fakeSync=this.sandbox.stub(i,"sync"),this.fakeShow=this.sandbox.stub(i,"show",function(e){e()}),this.container=e("<div>").attr("id","content").appendTo("#qunit-fixture"),this.box=e("<div></div>").appendTo("#qunit-fixture"),this.anchor=e("<a>test</a>").appendTo(this.box),this.tip=new n({body:"test "+new Date,anchor:this.anchor})},teardown:function(){this.container.remove(),this.box.remove(),this.tip=null,this.sandbox.restore(),e.fx.off=!1},setupSequences:function(){i.loaded=new s,i.showSequences(),i.loaded.resolve()},teardownSequences:function(){i.dismissedTipIds=[],i.loaded=new s,i.clearSequences(),i.loaded.resolve()}}),test("can be anchored to an element",function(){this.tip.show(),this.clock.tick(0),ok(this.tip.isVisible(),"tip should be visible")}),test("cannot be dismissed by clicking outside the tip",function(){this.tip.show(),this.clock.tick(0),e(document.body).trigger("click"),ok(this.tip.isVisible(),"tip should still be visible"),ok(!this.tip.isDismissed(),"not dismissed yet")}),test("tip disappears when dismissed",function(){this.tip.show(),this.clock.tick(0),this.tip.dismiss(),this.clock.tick(0),ok(!this.tip.isVisible(),"should no longer be visible")}),test("can click a close button to dismiss",function(){this.tip.show(),this.clock.tick(0);var t=e(".helptip-close",this.tip.view.$el);ok(t.length,"there should be a button on the anchored tip to dismiss it"),ok(!this.tip.isDismissed(),"is not yet dismissed"),t.trigger("click"),this.clock.tick(0),ok(this.tip.isDismissed(),"should be dismissed after clicking the close button")}),test("once dismissed, cannot be re-opened",function(){this.tip.show(),this.clock.tick(0),this.tip.dismiss(),this.clock.tick(0),this.tip.show(),ok(!this.tip.isVisible(),"should not be visible once closed")}),test("tip can be hidden",function(){this.tip.show(),this.clock.tick(0),this.tip.hide(),this.clock.tick(0),ok(!this.tip.isVisible(),"should be hidden")}),test("can show again after hide",function(){this.tip.show(),this.clock.tick(0),this.tip.hide(),this.clock.tick(0),this.tip.show(),this.clock.tick(0),ok(this.tip.isVisible(),"should be visible after hiding")}),test("refresh on a tip with hidden anchor hides the tip",function(){this.tip.show(),this.clock.tick(0),ok(this.tip.isVisible(),"should be visible"),this.anchor.hide(),this.clock.tick(0),ok(this.tip.isVisible(),"should be visible after anchor is hidden and refresh not called"),this.tip.refresh(),this.clock.tick(0),ok(!this.tip.isVisible(),"should not be visible after anchor is hidden and refresh called")}),test("refresh on a tip that isnt shown yet shows the tip",function(){ok(!this.tip.isVisible(),"should not be visible"),this.tip.refresh(),this.clock.tick(0),ok(this.tip.isVisible(),"should be visible after refresh")}),test("test inline dialog options is passed from helptip constructors",function(){expect(5);var s=this.sandbox.stub().returns({hide:e.noop});this.context.mock("aui/inline-dialog",s);var i=this.context.require("jira-help-tips/feature/help-tip"),n={offsetX:999,offsetY:-999,arrowOffsetX:9001,container:"fixture",initCallback:this.sandbox.spy()};new i({body:"test "+new Date,anchor:this.anchor,callbacks:{init:e.noop},inlineDialogOpts:n});var o=s.args[0][3];t.each(n,function(e,t){ok(o[t]===e,"options passed in from constructor should replace the default inline dialog options from helptip")})}),test("test helptips to be shown in sequence for next button",function(){e("#qunit-fixture").append("<a class='anchorOne'></a><a class='anchorTwo'></a>");var t=new n({id:"seq1",body:"I am a test 1.",isSequence:!0,anchor:".anchorOne"}),s=new n({id:"seq2",body:"I am a test 2.",isSequence:!0,anchor:".anchorTwo"});this.setupSequences();var i=e(".helptip-next",t.view.$el);equal(e(".helptip-sequence-paging",t.view.$el).text(),"1/2","Helptips include paging when shown in sequence"),equal(i.length,1,"Helptips include next button when shown in sequence"),i.click(),equal(e(".helptip-sequence-paging",s.view.$el).text(),"2/2","Helptips include paging when shown in sequence"),equal(e(".helptip-close",s.view.$el).length,1,"Helptips include close button when it is the last one"),equal(e(".helptip-next",s.view.$el).length,0,"Helptips does not include next button when it is the last one"),this.teardownSequences()}),test("test can move to the next help tip in sequence programatically",function(){e("#qunit-fixture").append("<a class='anchorOne'></a><a class='anchorTwo'></a>");var t=new n({id:"seq1",body:"I am a test 1.",isSequence:!0,anchor:".anchorOne"}),s=new n({id:"seq2",body:"I am a test 2.",isSequence:!0,anchor:".anchorTwo"});equal(e(".helptip-sequence-paging").length,0),this.setupSequences(),equal(e(".helptip-sequence-paging").length,1),equal(e(".helptip-sequence-paging").last().text(),"1/2"),t.showNextHelpTipInSequence(),equal(e(".helptip-sequence-paging").length,2),equal(e(".helptip-sequence-paging").last().text(),"2/2"),s.showNextHelpTipInSequence(),equal(e(".helptip-sequence-paging").length,2),this.teardownSequences()}),test("test never show paging info for non-sequence help tip",function(){e("#qunit-fixture").append("<a class='anchorOne'></a><a class='anchorTwo'></a><a class='anchorThree'></a>");var t=new n({id:"seq1",body:"I am a test 1.",isSequence:!0,anchor:".anchorOne"}),s=new n({id:"seq2",body:"I am a test 2.",isSequence:!0,anchor:".anchorTwo"}),i=new n({id:"non-seq",body:"I am a test 3.",isSequence:!1,anchor:".anchorThree"});equal(e(".helptip-sequence-paging").length,0),this.setupSequences(),i.show(),equal(e(".helptip-sequence-paging").length,1),equal(e(".helptip-sequence-paging").last().text(),"1/2"),t.showNextHelpTipInSequence(),equal(e(".helptip-sequence-paging").length,2),equal(e(".helptip-sequence-paging").last().text(),"2/2"),s.showNextHelpTipInSequence(),equal(e(".helptip-sequence-paging").length,2),this.teardownSequences()}),test("test close button will be enabled on last tip in sequence if last tip is filtered out as dismissed",function(){e("#qunit-fixture").append("<a class='anchorOne'></a><a class='anchorTwo'></a>");var t=new n({id:"seq1",body:"I am a test 1.",isSequence:!0,showCloseButton:!1,anchor:".anchorOne"});new n({id:"seq2",body:"I am a test 2.",isSequence:!0,showCloseButton:!0,anchor:".anchorTwo"}),i.dismissedTipIds=["seq2"],equal(e(".helptip-sequence-paging").length,0),this.setupSequences(),equal(e(".helptip-sequence-paging").length,0),equal(e(".helptip-close",t.view.$el).length,1,"Helptips include close button when it is the last one"),this.teardownSequences()}),test("test helptips to be shown in sequence for close button",function(){e("#qunit-fixture").append("<a class='anchorOne'></a><a class='anchorTwo'></a>");var t=new n({id:"seq1",body:"I am a test 1.",isSequence:!0,anchor:".anchorOne"}),s=new n({id:"seq2",body:"I am a test 2.",isSequence:!0,anchor:".anchorTwo"});this.setupSequences(),e(".helptip-close",t.view.$el).click(),equal(e(".helptip-body",s.view.$el).length,0,"Closing the first tip shouldn't open the second tip"),this.teardownSequences()}),test("test helptips can choose to not have a close button",function(){e("#qunit-fixture").append("<a class='anchorOne'></a>");var t=new n({id:"helptip",body:"I am a test.",showCloseButton:!1,anchor:".anchorOne"});t.show(),equal(e(".helptip-close",t.view.$el).length,0,"The helptip should not have a close button")}),test("test HelptipManager for tips to be shown in sequence",function(){e("#qunit-fixture").append("<a class='anchor'></a>");var t=new n({id:"seq1",body:"I am a test 1.",isSequence:!0,anchor:".anchor"});new n({id:"seq2",body:"I am a test 2.",isSequence:!0,anchor:".anchor"}),equal(i.sequences.length,2,"Helptips to be shown in sequence is added to the list"),this.setupSequences(),equal(i.sequences.length,2,"Helptips to be shown in sequence is added to the list"),equal(e(".helptip-sequence-paging",t.view.$el).text(),"1/2","Helptips include paging when shown in sequence"),equal(e(".helptip-close",t.view.$el).length,1,"Helptips include close button when shown in sequence"),equal(e(".helptip-next",t.view.$el).length,1,"Helptips include next button when shown in sequence"),i.dismissedTipIds.push("seq2"),this.setupSequences(),equal(i.sequences.length,1,"Helptips that have already been dismissed will not show"),equal(e(".helptip-sequence-paging",t.view.$el).length,0,"Helptips do not include paging when it is the only one"),equal(e(".helptip-close",t.view.$el).length,1,"Helptips include close button when it is the only one"),equal(e(".helptip-next",t.view.$el).length,0,"Helptips does not include next button when it is the only one"),this.teardownSequences()}),module("anchored tip with anchor selector",{setup:function(){e.fx.off=!0,this.sandbox=sinon.sandbox.create({useFakeTimers:!0,useFakeServer:!0}),this.clock=this.sandbox.clock,this.container=e("<div>").attr("id","content").appendTo("#qunit-fixture"),this.box=e("<div></div>").appendTo("#qunit-fixture"),this.anchorSelectorClass="anchor-selector-class",this.anchorSelector="."+this.anchorSelectorClass,this.anchor1=e("<a>test</a>").appendTo(this.box),this.anchor2=e("<a>test</a>").appendTo(this.box),this.anchor1.addClass(this.anchorSelectorClass),this.tip=new n({body:"test "+new Date,anchor:this.anchorSelector})},teardown:function(){this.tip=null,this.sandbox.restore(),e.fx.off=!1}}),test("visible when matching anchor is present after refresh",function(){this.tip.show(),this.clock.tick(0),ok(this.tip.isVisible(),"visible because the anchor selector matches"),this.tip.refresh(),this.clock.tick(0),ok(this.tip.isVisible(),"visible because the anchor selector matches")}),test("not visible when matching anchor is absent",function(){this.tip.show(),this.clock.tick(0),ok(this.tip.isVisible(),"visible because the anchor selector matches"),this.anchor1.removeClass(this.anchorSelectorClass),this.tip.refresh(),this.clock.tick(0),ok(!this.tip.isVisible(),"not visible because there are no anchors matching the selector")}),test("refresh on a change of anchor",function(){this.anchor1.addClass(this.anchorSelectorClass),this.tip.show(),this.clock.tick(0),ok(this.tip.isVisible(),"visible because the anchor selector matches"),this.anchor1.removeClass(this.anchorSelectorClass),this.anchor2.addClass(this.anchorSelectorClass),this.tip.refresh(),this.clock.tick(0),ok(this.tip.isVisible(),"visible because the second anchor matches")}),module("persistence",{setup:function(){var e=this.requests=[];this.xhr=sinon.useFakeXMLHttpRequest(),this.xhr.onCreate=function(t){e.push(t)}},teardown:function(){this.xhr.restore()}}),test("sends nothing to the server if no ID was set",function(){new n({body:"I have no ID-ah!"}).dismiss(),equal(this.requests.length,0,"no request was made to the server.")}),test("POSTs the dismissal of the tip to the server",function(){new n({id:"testtip2",body:"I am a test."}).dismiss(),equal(this.requests.length,1,"A request was sent to the server"),equal(this.requests[0].requestBody,JSON.stringify({id:"testtip2"}))})});