AJS.test.require(["com.atlassian.plugins.helptips.jira-help-tips:help-tip"], function () {
    "use strict";

    var Manager = require("jira-help-tips/feature/help-tip-manager");
    var HelpTip = require("jira-help-tips/feature/help-tip");
    var analytics = require("jira/analytics");
    var _ = require("underscore");

    module('analytics', {
        setup: function setup() {
            this.sandbox = sinon.sandbox.create();
            this.sandbox.stub(Manager, "sync");
            this.sandbox.stub(Manager, "show", function (showTip) {
                showTip();
            });
            this.sandbox.stub(analytics, "send");

            this.id = "help-tip-" + _.uniqueId();
            this.tip = new HelpTip({
                id: this.id,
                body: "whee"
            });
        },
        teardown: function teardown() {
            this.sandbox.restore();
        }
    });

    test('Shown event is fired', function () {
        this.tip.show();
        equal(analytics.send.callCount, 1, "Event has been fired");
        equal(analytics.send.args[0][0].name, "helptips." + this.id + ".shown", "Event has correct name");
    });

    test('Dismissed event is fired, with reason given', function () {
        this.tip.dismiss("thereason");
        equal(analytics.send.callCount, 1, "Event has been fired");
        equal(analytics.send.args[0][0].name, "helptips." + this.id + ".dismissed.thereason", "Event has correct name");
    });

    test('Dismissed event is fired, with no reason given', function () {
        this.tip.dismiss();
        equal(analytics.send.callCount, 1, "Event has been fired");
        equal(analytics.send.args[0][0].name, "helptips." + this.id + ".dismissed.programmatically", "Event has correct name");
    });

    test('Event prefix given', function () {
        this.tip = new HelpTip({
            id: this.id,
            body: "whee",
            eventPrefix: "foobar"
        });
        this.tip.show();
        equal(analytics.send.callCount, 1, "Event has been fired");
        equal(analytics.send.args[0][0].name, "foobar.helptips." + this.id + ".shown", "Event has correct name");
    });

    test('Tip with no ID fires no events', function () {
        this.tip = new HelpTip({
            body: "whee"
        });
        equal(analytics.send.callCount, 0, "No events were fired");
    });
});