AJS.test.require(["com.atlassian.plugins.helptips.jira-help-tips:common"], function () {
    "use strict";

    var Manager = require("jira-help-tips/feature/help-tip-manager");
    var HelpTip = require("jira-help-tips/feature/help-tip");
    var Dialog = require("jira/dialog/dialog");
    var $ = require("jquery");

    module('integration with JIRA', {
        setup: function setup() {
            $.fx.off = true;
            this.clock = sinon.useFakeTimers();
            this.fakeSync = sinon.stub(Manager, "sync");
            this.fakeShow = sinon.stub(Manager, "show", function (showTip) {
                showTip();
            });
            // the help tip dialog calculates its positions based off of an element with this ID... :\
            $("<div>").attr("id", "content").appendTo("#qunit-fixture");
        }, teardown: function teardown() {
            this.clock.restore();
            this.fakeShow.restore();
            this.fakeSync.restore();
            $.fx.off = false;
        }
    });

    test('open anchored tips do not stop dialogs from being closed', function () {
        var a = $("<a>thing</a>").appendTo("#qunit-fixture");
        var content = $("<div>I'm a dialog!</div>");
        var dialog = new Dialog({ content: content });
        var tip = new HelpTip({ body: "wheeeeee!", anchor: a });
        tip.show();
        this.clock.tick(0);
        ok(tip.isVisible());

        dialog.show();
        ok(dialog.$popup.is(":visible"), "dialog is visible");
        ok(tip.isVisible(), "tip is still visible after open of dialog");

        dialog.hide();
        ok(!dialog.$popup || !dialog.$popup.is(":visible"), "dialog closed fine while tip was open");
        ok(tip.isVisible(), "tip is still visible after close of dialog");
    });
});