require(['jquery', 'wrm/data', 'wrm/context-path', 'jira/analytics', 'jira/issuetable'], function ($, WrmData, wrmContextPath, analytics, IssueTable) {

    var moved = function moved(event) {
        return event.position.original !== event.position.current;
    };

    var movedUp = function movedUp(event) {
        return event.position.current < event.position.original;
    };

    var allRows = function allRows(event) {
        return $(event.row).parent().find("tr .stsequence div");
    };

    // Whenever a row is being dragged, we need to adjust sequence numbers of all of the affected rows.
    // But not for all rows, only for rows which are in dragging window.
    // Dragging window consist of rows which are between original location of the row being dragged
    // and its new location.

    // New sequence number depends on in which direction the row being dragged.
    // Whenever the row dragged up - sequence numbers of the rows in window should be increased.
    // Whenever the row dragged down - sequence number of the rows in window should be decreased.
    var movedRows = function movedRows(event) {
        var rows = allRows(event);
        var pos = event.position;

        if (movedUp(event)) {
            return rows.slice(pos.current + 1, pos.original + 1);
        } else {
            return rows.slice(pos.original, pos.current);
        }
    };

    WrmData.claim("com.atlassian.jira.jira-view-issue-plugin:controller-subtasks.controller.subtasks.parameters", function (config) {
        IssueTable.onTable(function (table) {
            var url = wrmContextPath() + config.url.replace("{issueId}", JIRA.Issue.getIssueId());

            $.get(url).success(function (allowed) {
                if (allowed) {
                    // If user is allowed to edit the issue
                    table.on(table.Events.ROW_DRAG_COMPLETED, function (event) {
                        if (moved(event)) {

                            $.ajax({
                                url: wrmContextPath() + config.url.replace("{issueId}", JIRA.Issue.getIssueId()),
                                type: "POST", // for jquery less then 1.9.0
                                method: "POST", // for jquery since 1.9.0
                                accept: "application/json",
                                contentType: "application/json",
                                data: JSON.stringify({
                                    original: event.position.original,
                                    current: event.position.current
                                }),
                                dataType: "json"
                            }).success(function () {
                                [].slice.call(allRows(event)).forEach(function (div, idx) {
                                    $(div).html(idx + 1 + ".");
                                });
                            }).fail(function () {
                                console.error("Unable to store updated issues position");
                                table.dragging.cancel();
                            });

                            analytics.send({
                                name: "com.atlassian.jira.view-issue-plugin.subtasks.drag.and.drop",
                                data: {
                                    direction: movedUp(event) ? "up" : "down",
                                    rowsCount: allRows(event).length,
                                    rowsUpdated: movedRows(event).length
                                }
                            });
                        }
                    });

                    table.dragging.enable();
                }
            });
        });
    }, function () {
        console.warn("Unable to read data from WRM");
    });
});