(function() {

	importer.ProjectModel = Backbone.Model.extend({
	});

	importer.MappingModel = Backbone.Model.extend({
	});

	importer.ProjectMappingView = Backbone.View.extend({
		events: {
			"click    .project_edit"	: "projectEdit",
			"selected .project_select"	: "projectSelected",
			"unselect .project_select"	: "projectUnselected"
		},

		initialize: function () {
			_.bindAll(this, "render", "_projectDetailsChange", "submitCleanup");
			this.projectsModel = this.options.projectsModel;
            this.canCreate = this.options.canCreate;
			this.projectSelect = new importer.NextButtonAwareSingleSelect({
				element: this.$(".project_select"),
				overlabel: "Select a project",
				itemAttrDisplayed: "label",
				mappingModel: this.model
			});

			this.editLink = this.$(".project_edit");
			this.iconRequired = this.$(".aui-icon.icon-required");

			this.model.bind("change", this.render);
			this.projectsModel.bind("add", this._projectDetailsChange);
			this.projectsModel.bind("change", this._projectDetailsChange);

			AJS.$(this.el).parents("form").bind("submit", this.submitCleanup);

			this._projectDetailsChange();
		},

		render: function () {
			var selected = this.model.get("selected");
			selected ? this._enableProjectImport() : this._disableProjectImport();

			var projectModel = this.model.get("projectModel");
			if (projectModel) {
				this.editLink.css("visibility", selected && projectModel.get("editable") ? "visible" : "hidden");
				this.iconRequired.hide();
				var previousDescriptor = this.projectSelect.getSelectedDescriptor();
				var previousModel = previousDescriptor && previousDescriptor.properties.projectModel;
				if (projectModel != previousModel) {
					this.projectSelect.selectByKey(projectModel.cid);
				}
			} else {
				this.editLink.css("visibility", "hidden");
				this.iconRequired.toggle(selected);
				this.projectSelect.clearSelection();
			}

			this.projectSelect.updateOverlabel();

			return this;
		},

		submitCleanup: function () {
			if (!this.projectSelect.getSelectedDescriptor()) {
				this.model.unset("projectModel", {silent: true});
			}
		},

		projectSelected: function (event, item, select) {
			if ("create-new" == item.value()) {
				var previousCId = (this.model.get("projectModel") || {}).cid;
				select.selectByKey(previousCId);
				lastTriggeredDialog = this;
				JPT.DialogController.handleProjectTemplateTriggered();
			} else {
				var selectedModel = item.properties.projectModel;
				this.model.set({projectModel: selectedModel});
			}
		},

		projectUnselected: function () {
			this.model.unset("projectModel");
		},

		projectEdit: function () {
			var popup = new importer.NewProjectDataDialog({
				editedModel: this.model.get("projectModel"),
				mappingModel: this.model,
				projectsModel: this.options.projectsModel,
				id: "jim-create-project-dialog"
			});
			popup.show();
		},

		_enableProjectImport: function () {
			this.projectSelect.enable();
			this.$(".error").show(); // created dynamically, don't store
		},

		_disableProjectImport: function () {
			this.projectSelect.disable();
			this.$(".error").hide();
		},

		_projectDetailsChange: function (changedModel) {
			var groupNew = new AJS.GroupDescriptor({
				showLabel: false,
				type: "optgroup",
				weight: 0,
				items: [ new AJS.ItemDescriptor({
					value: "create-new",
					label: "Create New"
				}) ]
			});

			var groupProjects = new AJS.GroupDescriptor({
				label: "Compatible Projects",
				type: "optgroup",
				weight: 1,
				items: this.projectsModel.map(function (model) {
					var suffix = " [" + model.get("key") + "]";
					var item = new AJS.ItemDescriptor({
						value: model.cid,
						label: model.get("name"),
						keywords: model.get("key"),
						projectModel: model
					});
					item.labelSuffix = function () { return suffix; };
					return item;
				})
			});

			this.projectSelect.model.appendOptionsFromJSON(this.canCreate ? [groupNew, groupProjects] : [groupProjects]);

			var selectedDescriptor = this.projectSelect.getSelectedDescriptor();
			if (changedModel && selectedDescriptor && selectedDescriptor.value() == changedModel.cid) {
				this.projectSelect.setSelection(selectedDescriptor); // so the name gets updated
			}
		}
	});


	/**
	 *  Here starts hack to allow Project Templates dialog to be used by JIM in JIRA 6.2+
	 *  This hack is no longer needed when we drop support for older JIRA versions <7.0
	 */
	var lastTriggeredDialog = null;
	var addProjectPanel;
	var originalCallbacks = JPT.AddProjectController.postProjectCreationCallbacks;

	function closeDialogAndUpdateUi(dialog, model) {
		dialog.remove();
		if (lastTriggeredDialog) {
			lastTriggeredDialog.options.projectsModel.add(model);
			lastTriggeredDialog.model.set({projectModel: model});
		} else {
			location.reload();
		}
	}

	//add ProjectView callback to have a hook on panel, to check selected checkboxes
	JPT.AddProjectView.addPostDrawCallback(function () {
		var dialog = JPT.DialogView.dialog || JPT.DialogView._dialog;
		addProjectPanel = dialog.getCurPanel();
	});

	// replace all project creation callbacks with ours
	JPT.AddProjectController.postProjectCreationCallbacks = [];
	JPT.AddProjectController.postProjectCreationCallbacks.push(function(dialog, returnUrl, projectId, projectKey, projectName) {
		var map = { key: projectKey, name: projectName, id: projectId, editable: false };
		var model = new importer.MappingModel(map);

		// Check if user has selected any associated resources
		var selectedCheckboxes = _.filter(addProjectPanel.body.find("input.remote-root.checkbox"), function (checkbox) {
			return checkbox.checked === true;
		});

		// If none was selected, don't run any callback as they will redirect/reload page
		if (selectedCheckboxes.length == 0) {
			closeDialogAndUpdateUi(dialog, model);
		} else {
			// If other resources should be created than run callbacks and intercept button clicks
			_.each(originalCallbacks, function(callback){
				callback(dialog, returnUrl, projectId, projectKey, projectName);
			});
			var finishButton = AJS.$(".project-create-acknowledge-button");
			if (finishButton) {
				finishButton.unbind("click");
				finishButton.on("click", function() {
					closeDialogAndUpdateUi(dialog, model);
				});
			}
		}
	});

})();