;define('jim/general/ImporterClicked', [
    "backbone",
    "jquery",
    "jim/general/view/dialogView",
    "jim/general/OnboardingAnalytics"
], function(
    Backbone,
    $,
    DialogView,
    Analytics
) {
    return Backbone.Marionette.Controller.extend({
        initialize: function(options) {
            var instance = this;

            this.analytics = new Analytics();
            this.model = options.model;

            if (this.model.get('dialogHtml')) {
                this.view = new DialogView({
                    model: this.model
                });
                this.view.render(this.model);
                this.view.on('documentation-clicked', function(model) {
                    instance.analytics.pushEvent('documentation-clicked', {
                        importer: model.get('uniqueId')
                    });
                });


            } else if (this.model.get('importerLink')) {
                AJS.reloadViaWindowLocation(this.model.get('importerLink'));
            }

            this.analytics.pushEvent("importer.clicked", { importer: this.model.get('uniqueId') });
        }
    });
});