AJS.$(function () {
	var CSVMappingView = Backbone.View.extend({
		events: {
			"change   #CSV_project_check": "projectImportToggle"
		},

		initialize: function () {
			_.bindAll(this, "render");

			this.projectMappingView = new importer.ProjectMappingView(this.options).render();

			this.projectRadio = this.$("#CSV_project_check");
            this.fromCsvRadio = this.$("#CSV_project_uncheck");

			this.model.bind("change", this.render);
		},

		projectImportToggle: function () {
            if(this.projectRadio.length > 0) {
			    this.model.set({selected: this.projectRadio.is(":checked")});
            } else {
                this.model.set({selected: true});
            }
		},

		render: function () {
			var selected = this.model.get("selected");
			if (selected) {
                this.fromCsvRadio.removeAttr("checked");
				this.projectRadio.attr("checked", "checked");
			} else {
				this.projectRadio.removeAttr("checked");
                this.fromCsvRadio.attr("checked", "checked");
			}
			this.projectMappingView.render();
			return this;
		}
	});

	var projectsModel = new Backbone.Collection({
		model: importer.ProjectModel
	});
	projectsModel.reset(AJS.$("#projectMappings").data("projects-model"));

	var mappingModel = new importer.MappingModel;
	mappingModel.set(AJS.$("#projectMappings").data("mappings-model"));

	var key = mappingModel.get("key");
	var projectModel = key && projectsModel.find(function(val) {
		return val.get("key") == key;
	});
	if (projectModel) {
		mappingModel.set({projectModel: projectModel});
	}

	new CSVMappingView({
			model: mappingModel,
			projectsModel: projectsModel,
            canCreate: AJS.$("#projectMappings").data("create-project"),
			el: ".CSV_project_wrapper"
	}).projectImportToggle();


	AJS.$("form[name=jiraform]").submit(function (event) {
		var mapping = mappingModel.get("projectModel");
		if (mapping) {
			var container = AJS.$(this);
			container.find("#CSV_project_key").val(mapping.get("key"));
			container.find("#CSV_project_name").val(mapping.get("name"));
		}
	});

	var updateNextButton = function() {
		var grayOut = mappingModel.get("selected") && ! mappingModel.get("projectModel");

		if (grayOut) {
			AJS.$("#nextButton").attr("disabled", "disabled");
		} else {
			AJS.$("#nextButton").removeAttr("disabled");
		}
	};



	mappingModel.bind("change:selected", updateNextButton);
	mappingModel.bind("change:projectModel", updateNextButton);
	AJS.$(updateNextButton);

});
