define("admin-updates/views/update/finish", ['require'], function (require) {
    "use strict";

    var Marionette = require('marionette');
    var Templates = require('admin-updates/templates');
    var ClusterStateModel = require('admin-updates/models/clusterstate');

    return Marionette.Layout.extend({
        template: Templates.finishUpdate,
        ui: {
            finishButton: "#finish-update-button",
            cancelButton: "#cancel-update-button",
            infoButton: "#info-button"
        },
        events: {
            "click @ui.finishButton": function clickUiFinishButton(e) {
                e.preventDefault();
                switch (this.model.get("state")) {
                    case ClusterStateModel.states.UPGRADE_TASKS_FAILED:
                        this.trigger("update:retry");break;
                    case ClusterStateModel.states.READY_TO_RUN_UPGRADE_TASKS:
                        this.trigger("update:finish");break;
                }
            },
            "click @ui.cancelButton": function clickUiCancelButton(e) {
                e.preventDefault();
                this.trigger("update:cancel");
            },
            "click @ui.infoButton": function clickUiInfoButton(e) {
                e.preventDefault();
                this.trigger("click:info-tooltip");
            }
        },
        initialize: function initialize() {
            this.listenTo(this.model, "change:state", function () {
                this.render();
            });
        },
        /**
         * Serializes the data that feeds into the template
         * @returns {{activeFinishButton: (boolean), activeCancelButton: (boolean)}}
         */
        serializeData: function serializeData() {
            return {
                activeFinishButton: this._shouldShowFinishButton(),
                activeCancelButton: this._shouldShowCancelButton(),
                isRetryUpgrade: this._isRetryUpgrade()
            };
        },
        /**
         * Whether or not to show the 'finish' button based on the model state
         * @returns {boolean}
         * @private
         */
        _shouldShowFinishButton: function _shouldShowFinishButton() {
            switch (this.model.get("state")) {
                case ClusterStateModel.states.READY_TO_RUN_UPGRADE_TASKS:
                case ClusterStateModel.states.UPGRADE_TASKS_FAILED:
                    return true;
                default:
                    return false;
            }
        },
        /**
         * Whether or not to show the 'cancel' button based on the model state
         * @returns {boolean}
         * @private
         */
        _shouldShowCancelButton: function _shouldShowCancelButton() {
            switch (this.model.get("state")) {
                case ClusterStateModel.states.READY_TO_UPGRADE:
                    return true;
                default:
                    return false;
            }
        },
        /**
         * Whether or not to show "Re-run upgrade" instead of "Run upgrade"
         * @returns {boolean}
         * @private
         */
        _isRetryUpgrade: function _isRetryUpgrade() {
            switch (this.model.get("state")) {
                case ClusterStateModel.states.UPGRADE_TASKS_FAILED:
                    return true;
                default:
                    return false;
            }
        }
    });
});