AJS.test.require(["com.atlassian.jira.jira-admin-updates-plugin:js-app"], function () {
    "use strict";

    require(['jquery', 'underscore', 'backbone', 'admin-updates/views/update/finish', 'admin-updates/models/clusterstate'], function (jQuery, _, Backbone, Finish, ClusterStateModel) {
        // Without this timeout, QUnit will wait indefinitely for async tests whose done() callback isn't called.
        QUnit.config.testTimeout = 5000;

        module("admin-updates/views/update/finish", {
            setup: function setup() {
                this.fixture = jQuery('#qunit-fixture');

                this.listener = _.extend({}, Backbone.Events);

                this.finish = new Finish({
                    el: this.fixture,
                    model: new ClusterStateModel({ state: ClusterStateModel.states.STABLE })
                });
                this.finish.render();
            }
        });

        test("clicking the finish button triggers the update:finish event", function (assert) {
            this.finish.model.set("state", ClusterStateModel.states.READY_TO_RUN_UPGRADE_TASKS);
            assert.expect(0);
            var done = assert.async();
            this.listener.listenTo(this.finish, "update:finish", done);

            this.finish.ui.finishButton.click();
        });

        test("clicking the re-run button triggers the update:retry event", function (assert) {
            this.finish.model.set("state", ClusterStateModel.states.UPGRADE_TASKS_FAILED);
            assert.expect(0);
            var done = assert.async();
            this.listener.listenTo(this.finish, "update:retry", done);

            this.finish.ui.finishButton.click();
        });

        test("clicking the cancel button triggers the update:cancel event", function (assert) {
            this.finish.model.set("state", ClusterStateModel.states.READY_TO_UPGRADE);
            assert.expect(0);
            var done = assert.async();
            this.listener.listenTo(this.finish, "update:cancel", done);

            this.finish.ui.cancelButton.click();
        });

        test("clicking the cancel tooltip triggers the click:info-tooltip event", function (assert) {
            assert.expect(0);
            var done = assert.async();
            this.listener.listenTo(this.finish, "click:info-tooltip", done);

            this.finish.ui.infoButton.click();
        });

        test("model change:state to READY_TO_RUN_UPGRADE_TASKS updates buttons", function () {
            ok(this.finish.ui.finishButton.prop("disabled"));
            ok(this.finish.ui.cancelButton.prop("disabled"));

            this.finish.model.set('state', ClusterStateModel.states.READY_TO_RUN_UPGRADE_TASKS);

            notOk(this.finish.ui.finishButton.prop("disabled"));
            ok(this.finish.ui.cancelButton.prop("disabled"));
        });

        test("model change:state to READY_TO_UPGRADE updates buttons", function () {
            ok(this.finish.ui.finishButton.prop("disabled"));
            ok(this.finish.ui.cancelButton.prop("disabled"));

            this.finish.model.set('state', ClusterStateModel.states.READY_TO_UPGRADE);

            ok(this.finish.ui.finishButton.prop("disabled"));
            notOk(this.finish.ui.cancelButton.prop("disabled"));
        });

        test("model change:state to RUNNING_UPGRADE_TASKS updates buttons", function () {
            ok(this.finish.ui.finishButton.prop("disabled"));
            ok(this.finish.ui.cancelButton.prop("disabled"));

            this.finish.model.set('state', ClusterStateModel.states.RUNNING_UPGRADE_TASKS);

            ok(this.finish.ui.finishButton.prop("disabled"));
            ok(this.finish.ui.cancelButton.prop("disabled"));
        });

        test("model change:state to STABLE updates buttons", function () {
            ok(this.finish.ui.finishButton.prop("disabled"));
            ok(this.finish.ui.cancelButton.prop("disabled"));

            this.finish.model.set('state', ClusterStateModel.states.STABLE);

            ok(this.finish.ui.finishButton.prop("disabled"));
            ok(this.finish.ui.cancelButton.prop("disabled"));
        });

        test("model change:state to MIXED updates buttons", function () {
            ok(this.finish.ui.finishButton.prop("disabled"));
            ok(this.finish.ui.cancelButton.prop("disabled"));

            this.finish.model.set('state', ClusterStateModel.states.MIXED);

            ok(this.finish.ui.finishButton.prop("disabled"));
            ok(this.finish.ui.cancelButton.prop("disabled"));
        });

        test("model change:state to UPGRADE_TASKS_FAILED updates buttons", function () {
            ok(this.finish.ui.finishButton.text() === 'update.finish.button.text');
            ok(this.finish.ui.finishButton.prop("disabled"));
            ok(this.finish.ui.cancelButton.prop("disabled"));

            this.finish.model.set('state', ClusterStateModel.states.UPGRADE_TASKS_FAILED);

            ok(this.finish.ui.finishButton.text() === 'update.retry.button.text');
            notOk(this.finish.ui.finishButton.prop("disabled"));
            ok(this.finish.ui.cancelButton.prop("disabled"));

            this.finish.model.set('state', ClusterStateModel.states.STABLE);

            ok(this.finish.ui.finishButton.text() === 'update.finish.button.text');
        });
    });
});