define('admin-updates/views/update/clusterstate', ['require'], function (require) {
    "use strict";

    var Marionette = require('marionette');
    var Templates = require('admin-updates/templates');
    var ClusterStateModel = require('admin-updates/models/clusterstate');
    var formatter = require('jira/util/formatter');

    return Marionette.ItemView.extend({
        tagName: 'span',
        template: Templates.clusterState,
        ui: {
            lozenge: "#cluster-state-lozenge",
            spinner: "#cluster-state-spinner-container"
        },
        /**
         * @param {Object} options.helpUrls
         */
        initialize: function initialize(options) {
            this.listenTo(this.model, {
                "fetch:started": this._showSpinner,
                "fetch:finished": this._hideSpinner,
                "fetch:failed": this._hideSpinner,
                "change:state": this.render
            });
            this.helpUrls = options.helpUrls;
        },
        serializeData: function serializeData() {
            return {
                id: 'cluster-state-lozenge',
                text: this._localizedState(),
                infoContent: this._getInfoContent(),
                extraClasses: this._getLozengeStyle()
            };
        },
        /**
         * @param {string} str
         * @returns {string}
         * @private
         */
        _replaceUnderscores: function _replaceUnderscores(str) {
            return str.replace(/_/g, " ");
        },
        _showSpinner: function _showSpinner() {
            this.ui.spinner.html(Templates.spinner({
                text: '',
                accessibilityText: formatter.I18n.getText('update.state.spinner.accessibility.text')
            }));
            this.ui.spinner.removeClass('hidden');
        },
        _hideSpinner: function _hideSpinner() {
            this.ui.spinner.addClass('hidden');
        },
        _getLozengeStyle: function _getLozengeStyle() {
            switch (this.model.get("state")) {
                case ClusterStateModel.states.STABLE:
                    return 'aui-lozenge-success';
                case ClusterStateModel.states.UPGRADE_TASKS_FAILED:
                    return 'aui-lozenge-error';
            }
            return 'aui-lozenge-current';
        },
        _getInfoContent: function _getInfoContent() {
            switch (this.model.get("state")) {
                case ClusterStateModel.states.READY_TO_UPGRADE:
                    return formatter.I18n.getText('update.state.readytoupgrade.infotext');
                case ClusterStateModel.states.MIXED:
                    return formatter.I18n.getText('update.state.mixed.infotext');
                case ClusterStateModel.states.READY_TO_RUN_UPGRADE_TASKS:
                    return formatter.I18n.getText('update.state.readytorunupgradetasks.infotext');
                case ClusterStateModel.states.RUNNING_UPGRADE_TASKS:
                    return formatter.I18n.getText('update.state.runningupgradetasks.infotext');
                case ClusterStateModel.states.UPGRADE_TASKS_FAILED:
                    return formatter.I18n.getText('update.state.upgradetasksfailed.infotext', this.helpUrls['debugging.upgrade.tasks']);
                case ClusterStateModel.states.STABLE:
                    return formatter.I18n.getText('update.state.stable.infotext');
            }

            return "";
        },
        _localizedState: function _localizedState() {
            switch (this.model.get('state')) {
                case ClusterStateModel.states.READY_TO_UPGRADE:
                    return formatter.I18n.getText('update.state.readytoupgrade');
                case ClusterStateModel.states.MIXED:
                    return formatter.I18n.getText('update.state.mixed');
                case ClusterStateModel.states.READY_TO_RUN_UPGRADE_TASKS:
                    return formatter.I18n.getText('update.state.readytorunupgradetasks');
                case ClusterStateModel.states.RUNNING_UPGRADE_TASKS:
                    return formatter.I18n.getText('update.state.runningupgradetasks');
                case ClusterStateModel.states.UPGRADE_TASKS_FAILED:
                    return formatter.I18n.getText('update.state.upgradetasksfailed');
                case ClusterStateModel.states.STABLE:
                    return formatter.I18n.getText('update.state.stable');
            }
        }
    });
});