AJS.test.require(["com.atlassian.jira.jira-admin-updates-plugin:js-app"], function () {
    "use strict";

    require(['jquery', 'admin-updates/views/update/clusterstate', 'admin-updates/models/clusterstate'], function (jQuery, ClusterStateView, ClusterStateModel) {
        module("admin-updates/views/update/clusterstate", {
            setup: function setup() {
                this.fixture = jQuery('#qunit-fixture');

                this.model = new ClusterStateModel({ state: ClusterStateModel.states.STABLE });

                this.defaultOpts = {
                    el: this.fixture,
                    model: this.model,
                    helpUrls: { 'debugging.upgrade.tasks': 'http://example.com/' }
                };

                this.clusterState = new ClusterStateView(this.defaultOpts);
                this.clusterState.render();
            }
        });

        test("It should listen to fetch:started from model and show the spinner", function () {
            var $spinner = jQuery(this.clusterState.ui.spinner.selector);

            this.model.trigger("fetch:started");

            equal($spinner.find(".aui-icon-wait").size(), 1);
            notOk($spinner.hasClass("hidden"));
        });

        test("It should listen to fetch:finished from model and hide the spinner", function () {
            var $spinner = jQuery(this.clusterState.ui.spinner.selector);

            this.model.trigger("fetch:finished");

            ok($spinner.hasClass("hidden"));
        });

        test("It should listen to fetch:failed from model and hide the spinner", function () {
            var $spinner = jQuery(this.clusterState.ui.spinner.selector);

            this.model.trigger("fetch:finished");

            ok($spinner.hasClass("hidden"));
        });

        test("It should listen to change:state from model and render the view", function () {
            var $lozenge = jQuery(this.clusterState.ui.lozenge.selector);
            equal($lozenge.text(), 'update.state.stable');

            this.model.set("state", ClusterStateModel.states.READY_TO_UPGRADE);
            $lozenge = jQuery(this.clusterState.ui.lozenge.selector);

            equal($lozenge.text(), 'update.state.readytoupgrade');
        });

        test("serializeData() should return the localised state", function () {
            this.model.set("state", ClusterStateModel.states.READY_TO_RUN_UPGRADE_TASKS);

            var data = this.clusterState.serializeData();

            equal(data.text, 'update.state.readytorunupgradetasks');
        });

        test("serializeData() should return the correct info text (STABLE)", function () {
            var data = this.clusterState.serializeData();

            equal(data.infoContent, "update.state.stable.infotext");
        });

        test("serializeData() should return the correct info text (READY_TO_UPGRADE)", function () {
            this.model.set("state", ClusterStateModel.states.READY_TO_UPGRADE);

            var data = this.clusterState.serializeData();

            equal(data.infoContent, "update.state.readytoupgrade.infotext");
        });

        test("serializeData() should return the correct info text (MIXED)", function () {
            this.model.set("state", ClusterStateModel.states.MIXED);

            var data = this.clusterState.serializeData();

            equal(data.infoContent, "update.state.mixed.infotext");
        });

        test("serializeData() should return the correct info text (READY_TO_RUN_UPGRADE_TASKS)", function () {
            this.model.set("state", ClusterStateModel.states.READY_TO_RUN_UPGRADE_TASKS);

            var data = this.clusterState.serializeData();

            equal(data.infoContent, "update.state.readytorunupgradetasks.infotext");
        });

        test("serializeData() should return the correct info text (RUNNING_UPGRADE_TASKS)", function () {
            this.model.set("state", ClusterStateModel.states.RUNNING_UPGRADE_TASKS);

            var data = this.clusterState.serializeData();

            equal(data.infoContent, "update.state.runningupgradetasks.infotext");
        });

        test("serializeData() should return the correct info text (UPGRADE_TASKS_FAILED)", function () {
            this.model.set("state", ClusterStateModel.states.UPGRADE_TASKS_FAILED);

            var data = this.clusterState.serializeData();

            equal(data.infoContent, "update.state.upgradetasksfailed.infotext");
        });

        test("serializeData() should return the correct lozenge style (STABLE)", function () {
            var data = this.clusterState.serializeData();

            equal(data.extraClasses, "aui-lozenge-success");
        });

        test("serializeData() should return the correct lozenge style (READY_TO_UPGRADE)", function () {
            this.model.set("state", ClusterStateModel.states.READY_TO_UPGRADE);

            var data = this.clusterState.serializeData();

            equal(data.extraClasses, "aui-lozenge-current");
        });

        test("serializeData() should return the correct lozenge style (MIXED)", function () {
            this.model.set("state", ClusterStateModel.states.MIXED);

            var data = this.clusterState.serializeData();

            equal(data.extraClasses, "aui-lozenge-current");
        });

        test("serializeData() should return the correct lozenge style (READY_TO_RUN_UPGRADE_TASKS)", function () {
            this.model.set("state", ClusterStateModel.states.READY_TO_RUN_UPGRADE_TASKS);

            var data = this.clusterState.serializeData();

            equal(data.extraClasses, "aui-lozenge-current");
        });

        test("serializeData() should return the correct lozenge style (RUNNING_UPGRADE_TASKS)", function () {
            this.model.set("state", ClusterStateModel.states.RUNNING_UPGRADE_TASKS);

            var data = this.clusterState.serializeData();

            equal(data.extraClasses, "aui-lozenge-current");
        });

        test("serializeData() should return the correct lozenge style (UPGRADE_TASKS_FAILED)", function () {
            this.model.set("state", ClusterStateModel.states.UPGRADE_TASKS_FAILED);

            var data = this.clusterState.serializeData();

            equal(data.extraClasses, "aui-lozenge-error");
        });

        test("the STABLE state should be localised", function () {
            this.model.set("state", ClusterStateModel.states.STABLE);

            var localised = this.clusterState.ui.lozenge.text();

            equal(localised, 'update.state.stable');
        });

        test("the READY_TO_UPGRADE state should be localised", function () {
            this.model.set("state", ClusterStateModel.states.READY_TO_UPGRADE);

            var localised = this.clusterState.ui.lozenge.text();

            equal(localised, 'update.state.readytoupgrade');
        });

        test("the MIXED state should be localised", function () {
            this.model.set("state", ClusterStateModel.states.MIXED);

            var localised = this.clusterState.ui.lozenge.text();

            equal(localised, 'update.state.mixed');
        });

        test("the READY_TO_RUN_UPGRADE_TASKS state should be localised", function () {
            this.model.set("state", ClusterStateModel.states.READY_TO_RUN_UPGRADE_TASKS);

            var localised = this.clusterState.ui.lozenge.text();

            equal(localised, 'update.state.readytorunupgradetasks');
        });

        test("the RUNNING_UPGRADE_TASKS state should be localised", function () {
            this.model.set("state", ClusterStateModel.states.RUNNING_UPGRADE_TASKS);

            var localised = this.clusterState.ui.lozenge.text();

            equal(localised, 'update.state.runningupgradetasks');
        });

        test("the UPGRADE_TASKS_FAILED state should be localised", function () {
            this.model.set("state", ClusterStateModel.states.UPGRADE_TASKS_FAILED);

            var localised = this.clusterState.ui.lozenge.text();

            equal(localised, 'update.state.upgradetasksfailed');
        });
    });
});