define("admin-updates/views/preupdate/togglecontentbutton", ['require'], function (require) {
    "use strict";

    var Marionette = require('marionette');
    var Templates = require('admin-updates/templates');
    var ClusterStateModel = require('admin-updates/models/clusterstate');
    var formatter = require('jira/util/formatter');

    return Marionette.Layout.extend({
        template: Templates.toggleContentButton,
        ui: {
            button: "#toggle-content-button",
            buttonIcon: ".aui-icon",
            buttonLabel: ".aui-button-label"
        },
        events: {
            "click @ui.button": function clickUiButton(e) {
                e.preventDefault();
                if (this._isExpanded()) {
                    this.trigger("content:collapse");
                } else {
                    this.trigger("content:expand");
                }
            }
        },
        initialize: function initialize() {
            this.listenTo(this.model, "change:state", function () {
                if (this._shouldSetButtonExpanded()) {
                    this.setButtonExpanded();
                } else {
                    this.setButtonCollapsed();
                }
            });
        },
        serializeData: function serializeData() {
            return {
                expanded: this._shouldSetButtonExpanded()
            };
        },
        _shouldSetButtonExpanded: function _shouldSetButtonExpanded() {
            return this.model.get("state") === ClusterStateModel.states.STABLE;
        },
        _isExpanded: function _isExpanded() {
            return this.ui.button.attr('aria-expanded') === "true";
        },
        setButtonExpanded: function setButtonExpanded() {
            this.ui.button.attr('aria-expanded', 'true');
            this.ui.buttonIcon.addClass('aui-iconfont-expanded');
            this.ui.buttonIcon.removeClass('aui-iconfont-collapsed');
            this.ui.buttonIcon.text(formatter.I18n.getText('preupdate.table.collapse.accessibility.text'));
            this.ui.buttonLabel.text(formatter.I18n.getText('preupdate.table.collapse'));
        },
        setButtonCollapsed: function setButtonCollapsed() {
            this.ui.button.attr('aria-expanded', 'false');
            this.ui.buttonIcon.addClass('aui-iconfont-collapsed');
            this.ui.buttonIcon.removeClass('aui-iconfont-expanded');
            this.ui.buttonIcon.text(formatter.I18n.getText('preupdate.table.expand.accessibility.text'));
            this.ui.buttonLabel.text(formatter.I18n.getText('preupdate.table.expand'));
        }
    });
});