AJS.test.require(["com.atlassian.jira.jira-admin-updates-plugin:js-app"],function(){"use strict";require(["jquery","underscore","backbone","admin-updates/models/healthcheckcollection","admin-updates/models/healthcheck","admin-updates/models/clusterstate","admin-updates/templates"],function(e,t,s,i,n,h,c){function a(e,t){return{severity:e,name:t,completeKey:e+"."+t,isHealthy:e===n.severity.UNDEFINED,failureReason:t+" reason"}}QUnit.config.testTimeout=5e3,module("admin-updates/views/preupdate/clusterhealth",{setup:function(){this.sandbox=sinon.sandbox.create(),this.listener=t.extend({},s.Events),this.fixture=e("#qunit-fixture"),this.healthChecks={critical:a(n.severity.CRITICAL,"critical"),major:a(n.severity.MAJOR,"major"),warning:a(n.severity.WARNING,"warning"),minor:a(n.severity.MINOR,"minor"),success:a(n.severity.UNDEFINED,"undefined")},this.model=new h({state:h.states.STABLE}),this.collection=new i([this.healthChecks.success,this.healthChecks.minor,this.healthChecks.warning,this.healthChecks.major,this.healthChecks.critical]),this.sandbox.stub(this.collection,"fetch"),this.context=AJS.test.mockableModuleContext(),this.context.mock("admin-updates/templates",c);var l=this.context.require("admin-updates/views/preupdate/clusterhealth");this.clusterHealth=new l({el:this.fixture,model:this.model,collection:this.collection}),this.clusterHealth.render(),this.sandbox.spy(this.clusterHealth,"expandContent"),this.sandbox.spy(this.clusterHealth,"collapseContent"),this.sandbox.spy(this.clusterHealth,"_getAggregatedText"),this.sandbox.spy(c,"spinner")},teardown:function(){this.sandbox.restore()}}),test("It should listen to change:state from model and run health checks",function(){this.model.trigger("change:state"),sinon.assert.calledOnce(this.collection.fetch)}),test("It should listen to change:state from model and expand content (STABLE)",function(){this.model.trigger("change:state"),sinon.assert.calledOnce(this.clusterHealth.expandContent)}),test("It should listen to change:state from model and collapse content (READY_TO_UPGRADE)",function(){this.model.set("state",h.states.READY_TO_UPGRADE),sinon.assert.calledOnce(this.clusterHealth.collapseContent)}),test("It should listen to change:state from model and collapse content (MIXED)",function(){this.model.set("state",h.states.MIXED),sinon.assert.calledOnce(this.clusterHealth.collapseContent)}),test("It should listen to change:state from model and collapse content (READY_TO_RUN_UPGRADE_TASKS)",function(){this.model.set("state",h.states.READY_TO_RUN_UPGRADE_TASKS),sinon.assert.calledOnce(this.clusterHealth.collapseContent)}),test("It should listen to change:state from model and collapse content (RUNNING_UPGRADE_TASKS)",function(){this.model.set("state",h.states.RUNNING_UPGRADE_TASKS),sinon.assert.calledOnce(this.clusterHealth.collapseContent)}),test("It should listen to healthcheck:started from collection and show spinner",function(){this.collection.trigger("healthcheck:started"),sinon.assert.calledOnce(c.spinner)}),test("It should listen to healthcheck:finished from collection and hide spinner",function(){notOk(this.clusterHealth.ui.waitContainer.hasClass("hidden")),this.collection.trigger("healthcheck:finished"),ok(this.clusterHealth.ui.waitContainer.hasClass("hidden"))}),test("It should listen to healthcheck:finished from collection and trigger change:icon (warning)",function(e){e.expect(1);var t=e.async();this.listener.listenTo(this.clusterHealth,"change:icon",function(e){equal(e,"zdu-icon-warning"),t()}),this.collection.trigger("healthcheck:finished")}),test("It should listen to healthcheck:finished from collection and trigger change:icon (success)",function(e){e.expect(1);var t=e.async();this.sandbox.stub(this.collection,"areAllChecksHealthy").returns(!0),this.listener.listenTo(this.clusterHealth,"change:icon",function(e){equal(e,"zdu-icon-success"),t()}),this.collection.trigger("healthcheck:finished")}),test("It should listen to healthcheck:finished from collection and show results (warning)",function(){this.collection.trigger("healthcheck:finished"),notOk(this.clusterHealth.ui.detailContainer.hasClass("hidden")),notOk(this.clusterHealth.ui.aggregateContainer.hasClass("hidden"))}),test("It should listen to healthcheck:finished from collection and show results (success)",function(){this.sandbox.stub(this.collection,"areAllChecksHealthy").returns(!0),this.collection.trigger("healthcheck:finished"),notOk(this.clusterHealth.ui.detailContainer.hasClass("hidden")),ok(this.clusterHealth.ui.aggregateContainer.hasClass("hidden"))}),test("The detailed health check should be the most severe issue",function(){this.collection.trigger("healthcheck:finished"),ok(this.clusterHealth.ui.detailContainer.text().indexOf(this.healthChecks.critical.name)>-1)}),test("The detailed health check should show the right icon (error)",function(){this.collection.trigger("healthcheck:finished"),ok(this.clusterHealth.ui.detailContainer.find(".aui-icon").attr("class").indexOf("error")>-1)}),test("The detailed health check should show the right icon (warning)",function(){this.collection.reset(),this.collection.add(a(n.severity.WARNING,"warning")),this.collection.trigger("healthcheck:finished"),ok(this.clusterHealth.ui.detailContainer.find(".aui-icon").attr("class").indexOf("warning")>-1)}),test("The aggregated health check should show the right number of checks (0 errors, 2 warnings)",function(){this.sandbox.stub(this.collection,"getMostSevereHealthCheck").returns(new n(a(n.severity.MAJOR,"major"))),this.collection.reset(),this.collection.add([a(n.severity.WARNING,"warning1"),a(n.severity.WARNING,"warning2")]),this.collection.trigger("healthcheck:finished");var e=this.clusterHealth.ui.aggregateContainer.text();sinon.assert.calledWith(this.clusterHealth._getAggregatedText,0,2),ok(e.indexOf("preupdate.instancehealth.checks.warnings.text")>-1),ok(-1===e.indexOf("preupdate.instancehealth.checks.error"))}),test("The aggregated health check should show the right number of checks (0 errors, 1 warning)",function(){this.sandbox.stub(this.collection,"getMostSevereHealthCheck").returns(new n(a(n.severity.MAJOR,"major"))),this.collection.reset(),this.collection.add(a(n.severity.WARNING,"warning")),this.collection.trigger("healthcheck:finished");var e=this.clusterHealth.ui.aggregateContainer.text();sinon.assert.calledWith(this.clusterHealth._getAggregatedText,0,1),ok(e.indexOf("preupdate.instancehealth.checks.warning.text")>-1),ok(-1===e.indexOf("preupdate.instancehealth.checks.error"))}),test("The aggregated health check should show the right number of checks (1 errors, 0 warning)",function(){this.sandbox.stub(this.collection,"getMostSevereHealthCheck").returns(new n(a(n.severity.CRITICAL,"critical"))),this.collection.reset(),this.collection.add(a(n.severity.MAJOR,"major")),this.collection.trigger("healthcheck:finished");var e=this.clusterHealth.ui.aggregateContainer.text();sinon.assert.calledWith(this.clusterHealth._getAggregatedText,1,0),ok(e.indexOf("preupdate.instancehealth.checks.error.text")>-1),ok(-1===e.indexOf("preupdate.instancehealth.checks.warning"))}),test("The aggregated health check should show the right number of checks (2 errors, 2 warning)",function(){this.sandbox.stub(this.collection,"getMostSevereHealthCheck").returns(new n(a(n.severity.CRITICAL,"critical"))),this.collection.reset(),this.collection.add(a(n.severity.MAJOR,"major1")),this.collection.add(a(n.severity.MAJOR,"major2")),this.collection.add(a(n.severity.WARNING,"warning1")),this.collection.add(a(n.severity.WARNING,"warning2")),this.collection.trigger("healthcheck:finished");var e=this.clusterHealth.ui.aggregateContainer.text();sinon.assert.calledWith(this.clusterHealth._getAggregatedText,2,2),ok(e.indexOf("preupdate.instancehealth.checks.errors.text")>-1),ok(e.indexOf("preupdate.instancehealth.checks.warnings.text")>-1)}),test("The aggregated health check should be hidden if there are none left",function(){this.sandbox.stub(this.collection,"getMostSevereHealthCheck").returns(new n(a(n.severity.MAJOR,"major"))),this.collection.reset(),this.collection.trigger("healthcheck:finished"),ok(this.clusterHealth.ui.aggregateContainer.is(":empty"))}),test("It emits an event when the health check link is clicked",function(){var e=this.sandbox.stub();this.listener.listenTo(this.clusterHealth,"click:health-check",e),this.clusterHealth.ui.healthCheckLink.click(),sinon.assert.calledOnce(e)})})});