define('admin-updates/modules/analytics', ['require'], function (require) {
    'use strict';

    var logger = require('jira/util/logger');
    var analytics = require('jira/analytics');

    return {
        recordInitialPageLoad: function recordInitialPageLoad(data) {
            if (!data || !data.clusterState) {
                logger.error("page-load event doesn't include cluster state data");
                return;
            }

            analytics.send({
                name: 'zdu.admin-updates-ui.page-load',
                properties: { clusterState: data.clusterState }
            });
        },
        recordIntroDocumentationClick: function recordIntroDocumentationClick() {
            analytics.send({ name: 'zdu.admin-updates-ui.documentation' });
        },
        recordViewHealthChecksClick: function recordViewHealthChecksClick() {
            analytics.send({ name: 'zdu.admin-updates-ui.pre-update.view-health-checks' });
        },
        recordCheckAddonsClick: function recordCheckAddonsClick() {
            analytics.send({ name: 'zdu.admin-updates-ui.pre-update.check-addons' });
        },
        recordDownloadLatestClick: function recordDownloadLatestClick() {
            analytics.send({ name: 'zdu.admin-updates-ui.pre-update.download-latest' });
        },
        recordBeginUpdateDialog: function recordBeginUpdateDialog() {
            analytics.send({ name: 'zdu.admin-updates-ui.dialog-begin-update' });
        },
        recordBeginUpdateConfirm: function recordBeginUpdateConfirm() {
            analytics.send({ name: 'zdu.admin-updates-ui.confirm-begin-update' });
        },
        recordCompleteUpdateDialog: function recordCompleteUpdateDialog() {
            analytics.send({ name: 'zdu.admin-updates-ui.dialog-complete-update' });
        },
        recordCompleteUpdateConfirm: function recordCompleteUpdateConfirm() {
            analytics.send({ name: 'zdu.admin-updates-ui.confirm-complete-update' });
        },
        recordRetryUpdateDialog: function recordRetryUpdateDialog() {
            analytics.send({ name: 'zdu.admin-updates-ui.dialog-retry-update' });
        },
        recordRetryUpdateConfirm: function recordRetryUpdateConfirm() {
            analytics.send({ name: 'zdu.admin-updates-ui.confirm-retry-update' });
        },
        recordCancelUpdateDialog: function recordCancelUpdateDialog() {
            analytics.send({ name: 'zdu.admin-updates-ui.dialog-cancel-update' });
        },
        recordCancelUpdateConfirm: function recordCancelUpdateConfirm() {
            analytics.send({ name: 'zdu.admin-updates-ui.confirm-cancel-update' });
        },
        recordInfoTooltipClick: function recordInfoTooltipClick(data) {
            if (!data || !data.clusterState) {
                logger.error("info-tooltip event doesn't include cluster state data");
                return;
            }

            analytics.send({
                name: 'zdu.admin-updates-ui.info-tooltip',
                properties: { clusterState: data.clusterState }
            });
        }
    };
});