AJS.test.require(["com.atlassian.jira.jira-admin-updates-plugin:js-app"],function(){"use strict";require(["underscore","backbone","admin-updates/services/update/clusterzdu"],function(t,e,s){function r(t){return new Promise(function(e){e(t)})}function a(t){return new Promise(function(e,s){s(t)})}QUnit.config.testTimeout=5e3,module("admin-updates/models/clusterstate",{setup:function(){this.listener=t.extend({},e.Events),this.sandbox=sinon.sandbox.create(),this.sandbox.stub(s,"startUpdate").returns(r()),this.sandbox.stub(s,"cancelUpdate").returns(r()),this.sandbox.stub(s,"finishUpdate").returns(r()),this.sandbox.stub(s,"retryUpdate").returns(r()),this.sandbox.stub(s,"clusterState").returns(r({state:"foo"})),this.context=AJS.test.mockableModuleContext(),this.context.mock("admin-updates/services/update/clusterzdu",s),this.ClusterState=this.context.require("admin-updates/models/clusterstate"),this.model=new this.ClusterState,this.sandbox.spy(this.model,"fetch")},teardown:function(){this.sandbox.restore()}}),test("fetch() should get the cluster state",function(){this.model.fetch(),sinon.assert.calledOnce(s.clusterState)}),test("fetch() should set the internal state",function(t){t.expect(1);var e=t.async();this.model.fetch(),Promise.resolve(s.clusterState).then(function(){equal(this.model.get("state"),"foo"),e()}.bind(this))}),test("startUpdate() should start the update",function(){this.model.startUpdate(),sinon.assert.calledOnce(s.startUpdate)}),test("startUpdate() should call fetch",function(t){t.expect(2);var e=t.async();this.model.startUpdate(),Promise.all([s.startUpdate,s.clusterState]).then(function(){sinon.assert.calledOnce(this.model.fetch),equal(this.model.get("state"),"foo"),e()}.bind(this))}),test("startUpdate() when the request fails because the transition is illegal, it should call fetch() to update state",function(t){t.expect(2);var e=t.async();s.startUpdate.restore(),this.sandbox.stub(s,"startUpdate").returns(a({status:409})),this.model.startUpdate(),Promise.reject(s.startUpdate).then(null,function(){Promise.resolve(s.clusterState).then(function(){sinon.assert.calledOnce(this.model.fetch),equal(this.model.get("state"),"foo"),e()}.bind(this))}.bind(this))}),test("startUpdate() when the request is rejected due to network/application error, it should emit a sync:error event (500 Internal Error)",function(t){t.expect(3);var e=t.async();s.startUpdate.restore(),this.sandbox.stub(s,"startUpdate").returns(a({status:500})),this.listener.listenTo(this.model,"sync:error",function(t,s,r){equal(t,"update.error.start.title"),equal(s,"update.error.network.application.text"),equal(r.status,500),e()}),this.model.startUpdate()}),test("startUpdate() when the request is rejected due to authorization error, it should emit a sync:error event (401 Unauthorized)",function(t){t.expect(3);var e=t.async();s.startUpdate.restore(),this.sandbox.stub(s,"startUpdate").returns(a({status:401})),this.listener.listenTo(this.model,"sync:error",function(t,s,r){equal(t,"update.error.start.title"),equal(s,"update.error.login.text"),equal(r.status,401),e()}),this.model.startUpdate()}),test("startUpdate() when the request is rejected due to permission error, it should emit a sync:error event (403 Forbidden)",function(t){t.expect(3);var e=t.async();s.startUpdate.restore(),this.sandbox.stub(s,"startUpdate").returns(a({status:403})),this.listener.listenTo(this.model,"sync:error",function(t,s,r){equal(t,"update.error.start.title"),equal(s,"update.error.permission.text"),equal(r.status,403),e()}),this.model.startUpdate()}),test("startUpdate() when the request is rejected due to state transition error, it should emit a sync:error event (409 Conflict)",function(t){t.expect(3);var e=t.async();s.startUpdate.restore(),this.sandbox.stub(s,"startUpdate").returns(a({status:409})),this.listener.listenTo(this.model,"sync:error",function(t,s,r){equal(t,"update.error.start.title"),equal(s,"update.error.transition.text"),equal(r.status,409),e()}),this.model.startUpdate()}),test("finishUpdate() should finish the update",function(){this.model.finishUpdate(),sinon.assert.calledOnce(s.finishUpdate)}),test("finishUpdate() should call fetch",function(t){t.expect(2);var e=t.async();this.model.finishUpdate(),Promise.all([s.finishUpdate,s.clusterState]).then(function(){sinon.assert.calledOnce(this.model.fetch),equal(this.model.get("state"),"foo"),e()}.bind(this))}),test("finishUpdate() when the request fails because the transition is illegal, it should call fetch() to update state",function(t){t.expect(2);var e=t.async();s.finishUpdate.restore(),this.sandbox.stub(s,"finishUpdate").returns(a({status:409})),this.model.finishUpdate(),Promise.reject(s.finishUpdate).then(null,function(){Promise.resolve(s.clusterState).then(function(){sinon.assert.calledOnce(this.model.fetch),equal(this.model.get("state"),"foo"),e()}.bind(this))}.bind(this))}),test("finishUpdate() when the request is rejected due to network/application error, it should emit a sync:error event (500 Internal Error)",function(t){t.expect(3);var e=t.async();s.finishUpdate.restore(),this.sandbox.stub(s,"finishUpdate").returns(a({status:500})),this.listener.listenTo(this.model,"sync:error",function(t,s,r){equal(t,"update.error.finish.title"),equal(s,"update.error.network.application.text"),equal(r.status,500),e()}),this.model.finishUpdate()}),test("finishUpdate() when the request is rejected due to authorization error, it should emit a sync:error event (401 Unauthorized)",function(t){t.expect(3);var e=t.async();s.finishUpdate.restore(),this.sandbox.stub(s,"finishUpdate").returns(a({status:401})),this.listener.listenTo(this.model,"sync:error",function(t,s,r){equal(t,"update.error.finish.title"),equal(s,"update.error.login.text"),equal(r.status,401),e()}),this.model.finishUpdate()}),test("finishUpdate() when the request is rejected due to permission error, it should emit a sync:error event (403 Forbidden)",function(t){t.expect(3);var e=t.async();s.finishUpdate.restore(),this.sandbox.stub(s,"finishUpdate").returns(a({status:403})),this.listener.listenTo(this.model,"sync:error",function(t,s,r){equal(t,"update.error.finish.title"),equal(s,"update.error.permission.text"),equal(r.status,403),e()}),this.model.finishUpdate()}),test("finishUpdate() when the request is rejected due to state transition error, it should emit a sync:error event (409 Conflict)",function(t){t.expect(3);var e=t.async();s.finishUpdate.restore(),this.sandbox.stub(s,"finishUpdate").returns(a({status:409})),this.listener.listenTo(this.model,"sync:error",function(t,s,r){equal(t,"update.error.finish.title"),equal(s,"update.error.transition.text"),equal(r.status,409),e()}),this.model.finishUpdate()}),test("retryUpdate() should finish the update",function(){this.model.retryUpdate(),sinon.assert.calledOnce(s.retryUpdate)}),test("retryUpdate() should call fetch",function(t){t.expect(2);var e=t.async();this.model.retryUpdate(),Promise.all([s.retryUpdate,s.clusterState]).then(function(){sinon.assert.calledOnce(this.model.fetch),equal(this.model.get("state"),"foo"),e()}.bind(this))}),test("retryUpdate() when the request fails because the transition is illegal, it should call fetch() to update state",function(t){t.expect(2);var e=t.async();s.retryUpdate.restore(),this.sandbox.stub(s,"retryUpdate").returns(a({status:409})),this.model.retryUpdate(),Promise.reject(s.retryUpdate).then(null,function(){Promise.resolve(s.clusterState).then(function(){sinon.assert.calledOnce(this.model.fetch),equal(this.model.get("state"),"foo"),e()}.bind(this))}.bind(this))}),test("retryUpdate() when the request is rejected due to network/application error, it should emit a sync:error event (500 Internal Error)",function(t){t.expect(3);var e=t.async();s.retryUpdate.restore(),this.sandbox.stub(s,"retryUpdate").returns(a({status:500})),this.listener.listenTo(this.model,"sync:error",function(t,s,r){equal(t,"update.error.retry.title"),equal(s,"update.error.network.application.text"),equal(r.status,500),e()}),this.model.retryUpdate()}),test("retryUpdate() when the request is rejected due to authorization error, it should emit a sync:error event (401 Unauthorized)",function(t){t.expect(3);var e=t.async();s.retryUpdate.restore(),this.sandbox.stub(s,"retryUpdate").returns(a({status:401})),this.listener.listenTo(this.model,"sync:error",function(t,s,r){equal(t,"update.error.retry.title"),equal(s,"update.error.login.text"),equal(r.status,401),e()}),this.model.retryUpdate()}),test("retryUpdate() when the request is rejected due to permission error, it should emit a sync:error event (403 Forbidden)",function(t){t.expect(3);var e=t.async();s.retryUpdate.restore(),this.sandbox.stub(s,"retryUpdate").returns(a({status:403})),this.listener.listenTo(this.model,"sync:error",function(t,s,r){equal(t,"update.error.retry.title"),equal(s,"update.error.permission.text"),equal(r.status,403),e()}),this.model.retryUpdate()}),test("retryUpdate() when the request is rejected due to state transition error, it should emit a sync:error event (409 Conflict)",function(t){t.expect(3);var e=t.async();s.retryUpdate.restore(),this.sandbox.stub(s,"retryUpdate").returns(a({status:409})),this.listener.listenTo(this.model,"sync:error",function(t,s,r){equal(t,"update.error.retry.title"),equal(s,"update.error.transition.text"),equal(r.status,409),e()}),this.model.retryUpdate()}),test("cancelUpdate() should cancel the update",function(){this.model.cancelUpdate(),sinon.assert.calledOnce(s.cancelUpdate)}),test("cancelUpdate() should call fetch",function(t){t.expect(2);var e=t.async();this.model.cancelUpdate(),Promise.all([s.cancelUpdate,s.clusterState]).then(function(){sinon.assert.calledOnce(this.model.fetch),equal(this.model.get("state"),"foo"),e()}.bind(this))}),test("cancelUpdate() when the request fails because the transition is illegal, it should call fetch() to update state",function(t){t.expect(2);var e=t.async();s.cancelUpdate.restore(),this.sandbox.stub(s,"cancelUpdate").returns(a({status:409})),this.model.cancelUpdate(),Promise.reject(s.cancelUpdate).then(null,function(){Promise.resolve(s.clusterState).then(function(){sinon.assert.calledOnce(this.model.fetch),equal(this.model.get("state"),"foo"),e()}.bind(this))}.bind(this))}),test("cancelUpdate() when the request is rejected due to network/application error, it should emit a sync:error event (500 Internal Error)",function(t){t.expect(3);var e=t.async();s.cancelUpdate.restore(),this.sandbox.stub(s,"cancelUpdate").returns(a({status:500})),this.listener.listenTo(this.model,"sync:error",function(t,s,r){equal(t,"update.error.cancel.title"),equal(s,"update.error.network.application.text"),equal(r.status,500),e()}),this.model.cancelUpdate()}),test("cancelUpdate() when the request is rejected due to authorization error, it should emit a sync:error event (401 Unauthorized)",function(t){t.expect(3);var e=t.async();s.cancelUpdate.restore(),this.sandbox.stub(s,"cancelUpdate").returns(a({status:401})),this.listener.listenTo(this.model,"sync:error",function(t,s,r){equal(t,"update.error.cancel.title"),equal(s,"update.error.login.text"),equal(r.status,401),e()}),this.model.cancelUpdate()}),test("cancelUpdate() when the request is rejected due to permission error, it should emit a sync:error event (403 Forbidden)",function(t){t.expect(3);var e=t.async();s.cancelUpdate.restore(),this.sandbox.stub(s,"cancelUpdate").returns(a({status:403})),this.listener.listenTo(this.model,"sync:error",function(t,s,r){equal(t,"update.error.cancel.title"),equal(s,"update.error.permission.text"),equal(r.status,403),e()}),this.model.cancelUpdate()}),test("cancelUpdate() when the request is rejected due to state transition error, it should emit a sync:error event (409 Conflict)",function(t){t.expect(3);var e=t.async();s.cancelUpdate.restore(),this.sandbox.stub(s,"cancelUpdate").returns(a({status:409})),this.listener.listenTo(this.model,"sync:error",function(t,s,r){equal(t,"update.error.cancel.title"),equal(s,"update.error.transition.text"),equal(r.status,409),e()}),this.model.cancelUpdate()}),test("When the state changes, it should emit a change:state event",function(t){t.expect(0),this.listener.listenTo(this.model,"change:state",t.async()),this.model.fetch()}),test("It should have all cluster zdu states",function(){deepEqual(this.ClusterState.states,{STABLE:"STABLE",READY_TO_UPGRADE:"READY_TO_UPGRADE",MIXED:"MIXED",READY_TO_RUN_UPGRADE_TASKS:"READY_TO_RUN_UPGRADE_TASKS",RUNNING_UPGRADE_TASKS:"RUNNING_UPGRADE_TASKS",UPGRADE_TASKS_FAILED:"UPGRADE_TASKS_FAILED"})})})});