AJS.test.require(["com.atlassian.jira.gadgets:common-test-resources","com.atlassian.jira.gadgets:piechart-dashboard-item-resources"],function(){function e(e){return e.replace(/&_=[^&?]*/,"")}var t=require("jquery"),s=require("jira-dashboard-items/piechart"),r={stats:[{value:"value1",label:"label1"},{value:"value2",label:"label2"},{value:"value3",label:"label3"}]},i={filterTitle:"title",filterUrl:"url",issueCount:8,statType:"issuetypes",results:[{key:"Feature",percentage:50,url:"urlFeature",value:4},{key:"Bug",percentage:25,url:"urlBug",value:2},{key:"Task",percentage:12,url:"urlTask",value:1},{key:"Other",percentage:12,url:"urlOther",value:1}]};module("jira-dashboard-items/piechart",{setup:function(){this.$el=t("<div/>"),this.$el.append(JIRA.DashboardItem.PieChart.Templates.PieChart());var e=t.extend({},DashboardItem.Mocks.API),r={delay:function(e){e()}};this.dashboardItem=new s(e,r),t("#qunit-fixture").append(this.$el),this.server=sinon.fakeServer.create()},teardown:function(){this.server.restore(),this.$el.remove()},testEditScreenBackwardsCompatibility:function(e,t,s){this.dashboardItem.filterTitleForEditScreen=s,this.dashboardItem.renderEdit(this.$el,{projectOrFilterId:e+"-"+t,statType:r.stats[0].value,refresh:15}),this.server.requests[0].respond(200,{"Content-Type":"application/json"},JSON.stringify(r)),equal(this.$el.find("input[name=name]").val(),s,"Name should be applied"),equal(this.$el.find("input[name=id]").val(),t,"Id should have been extracted"),equal(this.$el.find("input[name=type]").val(),e,"Type should have been extracted")}}),test("Should have loading display when requesting resources and success",function(){var e=sinon.spy(),t=sinon.spy();sinon.stub(this.dashboardItem.API,"showLoadingBar",e),sinon.stub(this.dashboardItem.API,"hideLoadingBar",t),this.dashboardItem.renderEdit(this.$el,{}),ok(e.calledOnce),this.server.requests[0].respond(200,{"Content-Type":"application/json"},JSON.stringify(r)),ok(t.calledOnce),equal(1,1)}),test("Should have loading display when requesting resources and failure",function(){var e=sinon.spy(),t=sinon.spy();sinon.stub(this.dashboardItem.API,"showLoadingBar",e),sinon.stub(this.dashboardItem.API,"hideLoadingBar",t),this.dashboardItem.renderEdit(this.$el,{}),ok(e.calledOnce),this.server.requests[0].respond(500,{"Content-Type":"application/json"},JSON.stringify({})),ok(t.calledOnce),equal(1,1)}),test("Requested stat items should get displayed in dropdown",function(){this.dashboardItem.renderEdit(this.$el,{}),equal(1,this.server.requests.length,"Should have a request for stat types"),this.server.requests[0].respond(200,{"Content-Type":"application/json"},JSON.stringify(r));var e=t("#"+this.dashboardItem.API.getGadgetId()+"-stat-type",this.$el),s=e.find("option");equal(s.length,r.stats.length,"Should have option for each stat");for(var i=0;i<s.length;++i)equal(t(s[i]).attr("value"),r.stats[i].value),equal(t(s[i]).text(),r.stats[i].label)}),test("Shows error when stat items could not be retired",function(){this.dashboardItem.renderEdit(this.$el,{}),this.server.requests[0].respond(500,{"Content-Type":"application/json"},"{}"),equal(this.$el.find(".aui-message.aui-message-error").length,1)}),test("Project/Filter autocomplete selections should be applied into the form",function(){this.dashboardItem.renderEdit(this.$el,{}),this.server.requests[0].respond(200,{"Content-Type":"application/json"},JSON.stringify(r));var e={projects:[{html:"<b>testProject</b>",id:1e4,key:"xyz",name:"test"}]},s=t("#"+this.dashboardItem.API.getGadgetId()+"-project-filter-picker",this.$el);s.val("a"),s.trigger(t.Event("keyup")),this.server.requests[1].respond(200,{"Content-Type":"application/json"},JSON.stringify(e)),t(".suggestions .aui-list-item").first().click(),equal(this.$el.find("input[name=id]").val(),1e4),equal(this.$el.find("input[name=type]").val(),"project"),equal(s.val(),"")}),test("Submitting the form sends a request with the correct values",function(){this.dashboardItem.renderEdit(this.$el,{}),this.server.requests[0].respond(200,{"Content-Type":"application/json"},JSON.stringify(r));var e={projects:[{html:"<b>testProject</b>",id:1e4,key:"xyz",name:"test"}]},s=t("#"+this.dashboardItem.API.getGadgetId()+"-project-filter-picker",this.$el);s.val("a"),s.trigger(t.Event("keyup")),this.server.requests[1].respond(200,{"Content-Type":"application/json"},JSON.stringify(e)),t(".suggestions .aui-list-item").first().click(),t("#"+this.dashboardItem.API.getGadgetId()+"-stat-type option",this.$el).first().attr("selected","true"),t("#"+this.dashboardItem.API.getGadgetId()+"-refresh-interval",this.$el).attr("checked","true");var i=sinon.spy();sinon.stub(this.dashboardItem.API,"savePreferences",i);this.dashboardItem.API.getRefreshFieldValue=sinon.stub().returns("15"),t("form",this.$el).submit();var a=i.args[0][0];equal(a.name,this.$el.find("input[name=name]").val(),"Should have gotten the name from the form"),equal(a.type,this.$el.find("input[name=type]").val(),"Should have gotten the type from the form"),equal(a.id,this.$el.find("input[name=id]").val(),"Should have gotten the id from the form"),equal(a.statType,this.$el.find("select[name=statType]").val(),"Should have gotten the statType from the form"),equal(a.refresh,this.$el.find("input[name=refresh-interval]").val(),"Should have gotten the refresh interval from the form")}),test("Saved gadget applies preferences to form",function(){this.dashboardItem.filterTitleForEditScreen="filter",this.dashboardItem.renderEdit(this.$el,{type:"type",id:1e4,statType:r.stats[0].value,isConfigured:!0,refresh:15}),this.server.requests[0].respond(200,{"Content-Type":"application/json"},JSON.stringify(r)),equal(this.$el.find("input[name=name]").val(),"filter","Expected name to be saved"),equal(this.$el.find("input[name=id]").val(),1e4,"Expected id to be saved"),equal(this.$el.find("input[name=type]").val(),"type","Expected type to be saved"),equal(this.$el.find("select[name=statType]").val(),r.stats[0].value,"Expected stat type to be saved"),equal(this.$el.find("input[name=refresh-interval]").val(),15,"Expected refresh interval to be saved")}),test("Rendering pie chart with no data displays message",function(){this.dashboardItem.render(this.$el,{type:"type",id:1e4,statType:r.stats[0].value,isConfigured:!0,refresh:15}),equal(this.server.requests.length,1,"Should have request for pie chart data"),this.server.requests[0].respond(200,{"Content-Type":"application/json"},JSON.stringify({results:[]})),equal(this.$el.find(".aui-message.aui-message-info").length,1)}),test("Rendering pie chart gadget creates pie chart",function(){this.dashboardItem.render(this.$el,{type:"type",id:1e4,statType:r.stats[0].value,isConfigured:!0,refresh:15}),this.server.requests[0].respond(200,{"Content-Type":"application/json"},JSON.stringify(i)),ok(1===this.$el.find(".piechart").length,"Rendered a pie chart")}),test("Error retrieving pie chart displays error",function(){this.dashboardItem.render(this.$el,{type:"type",id:1e4,statType:r.stats[0].value,isConfigured:!0,refresh:15}),this.server.requests[0].respond(500,{"Content-Type":"application/json"},JSON.stringify({})),ok(1===this.$el.find(".aui-message.aui-message-error").length,"Should have rendered an error aui message")}),test("Creating piechart generates a legend",function(){this.dashboardItem.render(this.$el,{type:"type",id:1e4,statType:r.stats[0].value,isConfigured:!0,refresh:15}),this.server.requests[0].respond(200,{"Content-Type":"application/json"},JSON.stringify(i)),ok(1===this.$el.find("ul.legend").length,"Should have found found the legend")}),test("Lots of sectors are grouped into an other",function(){this.dashboardItem.render(this.$el,{type:"type",id:1e4,statType:r.stats[0].value,isConfigured:!0,refresh:15});for(var e=[],t=0;t<this.dashboardItem.SECTOR_LIMIT-1;++t)e.push({key:"Feature"+t,percentage:50,url:"urlFeature",value:4});for(var s=[],i=0;i<5;++i)s.push({key:"OtherFeature"+i,percentage:50,url:"urlFeature",value:4});var a={filterTitle:"title",filterUrl:"url",issueCount:8,statType:"issuetypes",results:e.concat(s)};this.server.requests[0].respond(200,{"Content-Type":"application/json"},JSON.stringify(a)),equal(this.$el.find("ul.legend .legend-item").length,this.dashboardItem.SECTOR_LIMIT,"Should have created the limit of legend items in the legend"),equal(this.$el.find(".piechart-arc").length,this.dashboardItem.SECTOR_LIMIT,"Should have created the limit of sectors in the piechart");var n=this.$el.find("ul.legend .legend-item").last(),o=n.find(".legend-item-label");equal(o.text(),"common.words.other.no.dots..."),equal(n.find(".legend-item-value").text(),4*s.length)}),test("Edit screen should be backwards compatible for projects",function(){this.testEditScreenBackwardsCompatibility("project",1e4,"my new project")}),test("Edit screen should be backwards compatible for filters",function(){this.testEditScreenBackwardsCompatibility("filter",10100,"a filter")}),test("Request url for getting piechart data",function(){this.dashboardItem.render(this.$el,{type:"project",id:1e4,statType:r.stats[0].value,isConfigured:!0,refresh:15}),this.server.requests[0].respond(200,{"Content-Type":"application/json"},JSON.stringify(i));var e=this.server.requests[0].url;e=e.replace(/\?.*/,""),equal(e,AJS.contextPath()+"/rest/gadget/1.0/statistics")}),test("Generating jql for new preference structure",function(){this.dashboardItem.render(this.$el,{type:"filter",id:1e4,statType:r.stats[0].value,isConfigured:!0,refresh:15}),this.server.requests[0].respond(200,{"Content-Type":"application/json"},JSON.stringify(i));var t=this.server.requests[0].url;t=e(t),equal(t,AJS.contextPath()+"/rest/gadget/1.0/statistics?filterId=10000&statType="+r.stats[0].value)}),test("Test backward compatible preferences for query param arguments",function(){this.dashboardItem.render(this.$el,{projectOrFilterId:"project-10000",statType:r.stats[0].value,isConfigured:!0,refresh:15}),this.server.requests[0].respond(200,{"Content-Type":"application/json"},JSON.stringify(i));var t=this.server.requests[0].url;t=e(t),equal(t,AJS.contextPath()+"/rest/gadget/1.0/statistics?jql=project%3D10000&statType="+r.stats[0].value)}),test("Init refresh was called on render",function(){var e=sinon.spy();sinon.stub(this.dashboardItem.API,"initRefresh",e),this.dashboardItem.render(this.$el,{id:1e4,type:"project",statType:r.stats[0].value,isConfigured:!0,refresh:15}),this.server.requests[0].respond(200,{"Content-Type":"application/json"},JSON.stringify(i)),ok(e.calledOnce)}),test("Moving from rendered chart to edit actually shows edit screen",function(){this.dashboardItem.render(this.$el,{id:1e4,type:"project",statType:r.stats[0].value,isConfigured:!0,refresh:15}),this.server.requests[0].respond(200,{"Content-Type":"application/json"},JSON.stringify(i)),ok(this.$el.find(".piechart-with-legend").length>0,"Should have rendered the piechart"),this.dashboardItem.renderEdit(this.$el,{id:1e4,type:"project",statType:r.stats[0].value,isConfigured:!0,refresh:15}),this.server.requests[1].respond(200,{"Content-Type":"application/json"},JSON.stringify(r)),ok(0===this.$el.find(".piechart-with-legend").length,"Should not have a rendered piechart"),ok(1===this.$el.find(".dashboard-item-preferences-config").length,"Should have rendered piechart configuraton")})});