AJS.test.require(["com.atlassian.jira.gadgets:common-test-resources","com.atlassian.jira.gadgets:filter-results-dashboard-item-resources"],function(){"use strict";function e(e,t){return function(){return{init:function(){return this},getValue:function(){return e},validate:function(){return t}}}}var t=require("jquery");module("jira-dashboard-items/filter-results",{setup:function(){this.mockedContext=AJS.test.mockableModuleContext(),this.API=t.extend({},DashboardItem.Mocks.API),this.APIStub=sinon.stub(this.API),this.$el=t("<div/>"),t("#qunit-fixture").append(this.$el),this.server=sinon.fakeServer.create()},teardown:function(){this.server.restore(),this.$el.empty()},assertCommonAPIMethodsCalled:function(){sinon.assert.calledOnce(this.APIStub.showLoadingBar,"Loading bar was shown"),sinon.assert.calledOnce(this.APIStub.initRefresh,"Refresh of the dashboarditem was initialised"),sinon.assert.calledOnce(this.APIStub.resize,"Layout refreshed after render")},submitConfigFormWithValues:function(t,s,r){this.mockedContext.mock("jira-dashboard-items/components/filter-picker",e({id:"12345"},s)),this.mockedContext.mock("jira-dashboard-items/components/column-picker",e("summary|description",r)),new(this.mockedContext.require("jira-dashboard-items/filter-results"))(this.API).renderEdit(this.$el,{}),this.$el.find("input[name=number-results]").val(t),this.$el.find("form").submit()},renderFilterResults:function(e,s,r){var i=t.Deferred();return this.mockedContext.mock("jira-dashboard-items/components/search-results",function(e){return equal(s,e.preferences.filterId),{render:function(){return e[r](),i},on:function(e,t){}}}),new(this.mockedContext.require("jira-dashboard-items/filter-results"))(this.API).render(this.$el,{filterId:e}),i}}),test("Render with old filter id pref normalizes filter id and calls appropriate API methods",function(){var e=this.renderFilterResults("filter-12345",12345,"onContentLoaded");this.assertCommonAPIMethodsCalled(),e.resolve({title:"New Filter"}),sinon.assert.calledOnce(this.APIStub.hideLoadingBar,"Hide the loading bar"),sinon.assert.calledOnce(this.APIStub.setTitle,"Title was set after load"),sinon.assert.calledWith(this.APIStub.setTitle,"gadget.filter.results.specific.title"),equal("",this.$el.text())}),test("Render may error out",function(){var e=this.renderFilterResults("12345",12345,"onError");this.assertCommonAPIMethodsCalled(),e.resolve(),sinon.assert.calledOnce(this.APIStub.hideLoadingBar,"Hide the loading bar"),equal("dashboard.item.filter.results.invalid.filter",this.$el.text(),"Element contains error")}),test("Render may return no results out",function(){var e=this.renderFilterResults("12345",12345,"onEmptyResult");this.assertCommonAPIMethodsCalled(),e.resolve(),sinon.assert.calledOnce(this.APIStub.hideLoadingBar,"Hide the loading bar"),equal("gadget.issuetable.common.empty",this.$el.text(),"Element contains error")}),test("Validation of number to show field triggers error",function(){this.submitConfigFormWithValues("not a number!",!0,!0),sinon.assert.calledOnce(this.APIStub.resize,"Layout refreshed after render"),sinon.assert.notCalled(this.APIStub.savePreferences,"savePrefs wasn't called");var e=this.$el.find("input[name=number-results]");ok(e.next(".error").is(":visible"),"Error shown"),equal("gadget.common.num.nan",e.next(".error").text(),"Correct message shown")}),test("Validation of filter picker triggers error",function(){this.submitConfigFormWithValues("30",!1,!0),sinon.assert.calledOnce(this.APIStub.resize,"Layout refreshed after render"),sinon.assert.notCalled(this.APIStub.savePreferences,"savePrefs wasn't called")}),test("Validation of column picker triggers error",function(){this.submitConfigFormWithValues("30",!0,!1),sinon.assert.calledOnce(this.APIStub.resize,"Layout refreshed after render"),sinon.assert.notCalled(this.APIStub.savePreferences,"savePrefs wasn't called")}),test("Save Prefs called once validation passes",function(){this.API.getRefreshFieldValue=sinon.stub().returns("false"),this.submitConfigFormWithValues("30",!0,!0),sinon.assert.calledOnce(this.APIStub.savePreferences,"savePrefs was called"),sinon.assert.calledWith(this.APIStub.savePreferences,{num:"30",filterId:"12345",refresh:"false",columnNames:"summary|description"})})});