AJS.test.require(["com.atlassian.jira.gadgets:common-test-resources","com.atlassian.jira.gadgets:favourite-filters-dashboard-item-resources"],function(){"use strict";var e=require("jquery"),t=require("underscore"),s=require("jira-dashboard-items/favourite-filters"),r={filters:[{label:"Three",value:10302,count:22},{label:"Two",value:10301,count:27}],includeCount:!0},n={filters:[{label:"Three",value:10302},{label:"Two",value:10301}],includeCount:!1};module("Favourite Filters dashboard item tests",{setup:function(){this.$el=e("<div/>"),this.API=e.extend({},DashboardItem.Mocks.API),this.dashboardItem=new s(this.API),e("#qunit-fixture").append(this.$el),this.server=sinon.fakeServer.create()},teardown:function(){this.server.restore()},assertCorrectFilters:function(s){var r=this.$el.find(".filter-list-content table");equal(r.find("tr").length,s.length,"Same number of filters"),t.each(s,function(t,s){var n=e(r.find("tr")[s]);equal(e(n.find("td")[0]).text(),t.name,"Filter name matches"),null===t.count?equal(n.find("td").length,1,"Should only be one table column for each filter"):equal(e(n.find("td")[1]).text(),t.count,"Filter count matches")})},assertOperationsPresent:function(){var t=this.$el.find(".operations-list a");equal(e(t[0]).text(),"gadget.favourite.filters.create.new.filter","Create new link present"),equal(e(t[1]).text(),"gadget.favourite.filters.manage.filters","Manage link present")}}),test("Server error renders error message in item",function(){this.dashboardItem.render(this.$el,{showCounts:!0}),this.server.requests[0].respond(500,{"Content-Type":"application/json"},JSON.stringify({})),equal(this.$el.text(),"dashboard.item.favourite.filters.error","Should have shown appropriate error on server error")}),test("Empty result renders empty view",function(){this.dashboardItem.render(this.$el,{showCounts:!0}),this.server.requests[0].respond(200,{"Content-Type":"application/json"},JSON.stringify({filters:[]})),equal(this.$el.find(".empty-msg").text(),"dashboard.item.favourite.filters.empty","Empty message is shown");var t=this.$el.find(".aui-button");equal(t.length,2,"Should have 2 buttons to create and manage filters"),equal(e(t[0]).text(),"gadget.favourite.filters.create.new.filter","Create button has correct text"),equal(e(t[1]).text(),"gadget.favourite.filters.manage.filters","Manage button has correct text")}),test("Results with counts are rendered correctly",function(){this.dashboardItem.render(this.$el,{showCounts:!0}),this.server.requests[0].respond(200,{"Content-Type":"application/json"},JSON.stringify(r)),this.assertCorrectFilters([{name:"Three",count:22},{name:"Two",count:27}]),this.assertOperationsPresent()}),test("Results without counts are rendered correctly",function(){this.dashboardItem.render(this.$el,{showCounts:!1}),this.server.requests[0].respond(200,{"Content-Type":"application/json"},JSON.stringify(n)),this.assertCorrectFilters([{name:"Three",count:null},{name:"Two",count:null}]),this.assertOperationsPresent()}),test("Config prefs are saved correctly",function(){var t=sinon.spy();sinon.stub(this.dashboardItem.API,"savePreferences",t),this.dashboardItem.renderEdit(this.$el,{}),e("form",this.$el).submit();var s=t.args[0][0];equal(s.showCounts,!1,"Show counts wasn't checked so should be false")}),test("Config prefs are saved correctly when showCounts is checked",function(){var t=sinon.spy();sinon.stub(this.dashboardItem.API,"savePreferences",t),this.dashboardItem.renderEdit(this.$el,{}),this.$el.find("input[name=showCounts]").prop("checked",!0),e("form",this.$el).submit();var s=t.args[0][0];equal(s.showCounts,!0,"Show counts wasn checked so should be true")})});