/**
 * @fileoverview Implements the gadgets.UserPrefStore interface storing data in a javascript store.
 */
define("jira/ajs/gadget/chartpopup/user-preference-store", [], function () {
    "use strict";

    var userPrefMap = {};
    return {
        get: function get(gadgetId) {
            var userPrefs = userPrefMap[gadgetId];
            if (!userPrefs) {
                return {};
            }
            return userPrefs;
        },
        set: function set(gadgetId, name, value) {
            var prefs = this.get(gadgetId);
            prefs[name] = value;
            userPrefMap[gadgetId] = prefs;
        },
        clear: function clear() {
            userPrefMap = {};
        }
    };
});