define("jira/components/util/functionalutils", ['require'], function (require) {
    "use strict";

    var _ = require('jira/components/libs/underscore');

    return {
        lambda: function(x) {
            return function() {
                return x;
            };
        },
        isNotBlank: function(object) {
            return !!object;
        },
        bindObjectTo: function (obj, context) {
            _.map(obj, function (value, key) {
                if (_.isFunction(value)) {
                    obj[key] = _.bind(value, context);
                }
            });
        }
    };
});
