AJS.test.require("com.atlassian.jira.jira-issue-nav-components:simpleissuelist-test", function() {
    "use strict";

    require([
        "jira/components/simpleissuelist/views/pagination",
        "jira/components/libs/backbone",
        "jira/components/libs/underscore"
    ], function(
        Pagination,
        Backbone,
        _
    ) {
        module("jira/components/simpleissuelist/views/pagination", {

            renderView: function(collection) {
                var view = new Pagination({
                    collection: collection || this.createPaginationCollection()
                });
                view.render();
                return view;
            },

            createPaginationCollection: function(options) {
                options = _.defaults(options || {}, {
                    pageSize: 5,
                    currentPage: 2,
                    totalRecords: 24,
                    jql: 'project=DEMO'
                });

                var collection = new Backbone.Collection();
                collection.state = {
                    pageSize: options.pageSize,
                    totalRecords: options.totalRecords,
                    currentPage: options.currentPage
                };
                collection.searchParams = {
                    jql: options.jql
                };
                return collection;
            }
        });

        test("It should not render the 'prev' arrow if the first page is active", function() {
            var view = this.renderView(this.createPaginationCollection({
                currentPage: 0
            }));
            equal(view.ui.prev.length, 0);
        });

        test("It should not render the 'next' arrow if the last page is active", function() {
            var view = this.renderView(this.createPaginationCollection({
                currentPage: 4
            }));
            equal(view.ui.next.length, 0);
        });

        test("It render both arrows if the selected page is somewhere in the middle", function() {
            var view = this.renderView(this.createPaginationCollection({
                currentPage: 3
            }));
            equal(view.ui.prev.length, 1);
            equal(view.ui.next.length, 1);
        });

        test("It renders the selected page", function() {
            var view = this.renderView(this.createPaginationCollection({
                currentPage: 2
            }));

            equal(view.$el.find("strong").length, 1);
            equal(view.$el.find("strong").text(), "3");
        });

        test("It render non selected pages as links", function() {
            var view = this.renderView(this.createPaginationCollection({
                currentPage: 0,
                totalRecords: 15
            }));

            equal(view.ui.page.length, 2);
            equal(view.ui.page.eq(0).text(), "2");
            equal(view.ui.page.eq(1).text(), "3");
        });

        test("It renders nothing if there is only one page", function() {
            var view = this.renderView(this.createPaginationCollection({
                currentPage: 0,
                totalRecords: 2
            }));

            equal(view.$el.children().length, 0);
        });

        test("Clicking on the next arrow should trigger the 'next' event", function() {
            var view = this.renderView();
            var spy = this.spy();
            view.on('next', spy);

            view.ui.next.click();

            sinon.assert.calledOnce(spy);
        });

        test("Clicking on the prev arrow should trigger the 'prev' event", function() {
            var view = this.renderView();
            var spy = this.spy();
            view.on('prev', spy);

            view.ui.prev.click();

            sinon.assert.calledOnce(spy);
        });

        test("Clicking on a page should trigger the 'goto' event with the page number", function() {
            var view = this.renderView();
            var spy = this.spy();
            view.on('goto', spy);

            // Click on the first clickable page, 'Issues 1 to 5'
            view.ui.page.eq(0).click();

            sinon.assert.calledOnce(spy);
            sinon.assert.calledWith(spy, 0);
        });

        test("When the collection is updated with a new set of results, it re-renders itself with the new values", function() {
            var collection = this.createPaginationCollection({
                currentPage: 0,
                pageSize: 5,
                totalRecords: 15
            });
            var view = this.renderView(collection);

            view.update(this.createPaginationCollection({
                currentPage: 1,
                pageSize: 5,
                totalRecords: 15
            }));

            equal(view.$el.find("strong").text(), "2");
        });
    });

});
