define("jira/components/simpleissuelist/views/layout", ['require'], function (require) {
    "use strict";

    var Marionette = require('jira/components/libs/marionette-2.1.0');
    var Templates = require('jira/components/simpleissuelist/templates');

    return Marionette.LayoutView.extend({
        template: Templates.layout,

        regions: {
            pagination: ".pagination-container",
            refresh: ".refresh-container",
            searchResults: ".search-results",
            orderBy: ".list-ordering",
            endOfStableMessageContainer: '.end-of-stable-message-container',
            inlineIssueCreateContainer: '.inline-issue-create-container'
        },

        ui: {
            listPanel: ".list-panel"
        },

        showLoading: function() {
            this.ui.listPanel.addClass("loading");
        },

        hideLoading: function() {
            this.ui.listPanel.removeClass("loading");
        }
    });
});
