AJS.test.require("com.atlassian.jira.jira-issue-nav-components:simpleissuelist-test", function() {
    "use strict";

    require([
        "jira/components/simpleissuelist/views/layout"
    ], function(
        Layout
    ) {
        module("jira/components/simpleissuelist/views/layout", {
            setup: function() {
                this.view = new Layout();
                this.view.render();
            },

            assertRegion: function(regionName) {
                this.view[regionName]._ensureElement();
                equal(this.view[regionName].$el.length, 1);
            }
        });

        test("It exports a 'pagination' region", function() {
            this.assertRegion('pagination');
        });

        test("It exports a 'refresh' region", function() {
            this.assertRegion('refresh');
        });

        test("It exports a 'searchResults' region", function() {
            this.assertRegion('searchResults');
        });

        test("It exports a 'orderBy' region", function() {
            this.assertRegion('orderBy');
        });

        test("It exports a 'endOfStableMessageContainer' region", function() {
            this.assertRegion('endOfStableMessageContainer');
        });

        test("It exports a 'inlineIssueCreateContainer' region", function() {
            this.assertRegion('inlineIssueCreateContainer');
        });

        test("It exports a 'listPanel' ui component", function() {
            equal(this.view.ui.listPanel.length, 1);
        });
    });

});
