define("jira/components/simpleissuelist/views/issue", ['require'], function (require) {
    "use strict";

    var Marionette = require('jira/components/libs/marionette-2.1.0');
    var Templates = require('jira/components/simpleissuelist/templates');

    return Marionette.ItemView.extend({
        template: Templates.issue,

        ui: {
            link: 'a'
        },

        events: {
            'simpleClick': function (ev) {
                ev.preventDefault();
                this.trigger('select');
            }
        },

        serializeData: function() {
            var model = this.model;
            return {
                "id": model.get("id"),
                "key": model.get("key"),
                "summary": model.get("summary"),
                "typeName": model.get("type").name,
                "typeDescription": model.get("type").description,
                "typeIcon": model.get("type").iconUrl
            };
        },

        onRender: function() {
            this.unwrapTemplate();
        },

        highlight: function() {
            this.$el.addClass("focused");
            this.focus();
            this.scrollIntoView();
        },

        unhighlight: function() {
            this.$el.removeClass("focused");
        },

        scrollIntoView: function() {
            this.$el.scrollIntoViewForAuto();
        },

        focus: function() {
            this.ui.link.focus();
        }
    });
});
