AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:testutils", "com.atlassian.jira.jira-issue-nav-components:query"], function() {
    "use strict";

    var TestUtils = require("jira/issues/components/testutils");

    require([
        "jquery",
        "jira/components/query/jql/jqlqueryview",
        "jira/components/query/templates/issuenavqueryjql"
    ], function(
        jQuery,
        JqlQueryView,
        IssueNavQueryJql
    ) {
        module("jira/components/query/jql/jqlqueryview", {
            setup: function() {
                this.$el = jQuery('<div>').appendTo('body');

                this.queryModule = TestUtils.mockQueryModule();
                this.queryStateModel = TestUtils.mockQueryStateModel();

                this.queryModule.searchersReady = function() {
                    return new jQuery.Deferred().resolve();
                };

                this.view = new JqlQueryView({
                    queryStateModel: this.queryStateModel,
                    el: this.$el
                });
            },
            teardown: function() {
                this.$el.remove();
            }
        });

        test("Jql query view template exists", function() {
            ok(IssueNavQueryJql.jqlQueryView, "Template exists");
        });

        test("View renders something", function() {
            this.view.render();
            equal(this.$el.find("textarea").length, 1, "View renders something");
        });

        test("Empty text builds jql correctly", function() {
            this.view.render();

            equal(this.view.readJql(), "");
        });

        test("Setting text builds jql correctly", function() {
            this.view.render();

            this.$el.find("textarea").val("project = 'world domination' AND fixVersion = 6.6.6");

            equal(this.view.readJql(), "project = 'world domination' AND fixVersion = 6.6.6");
        });

        test("Resetting text to empty builds jql correctly", function() {
            this.view.render();

            this.$el.find("input").val("text ~ ohyeah");
            this.$el.find("input").val("");

            equal(this.view.readJql(), "");
        });

        test("Updating jql property updates text area", function() {
            this.view.render();
            this.queryStateModel.setJql("this is some freakin jql");
            equal(this.$el.find("textarea").val(), "this is some freakin jql");
        });

        test("It reads the Jql from the field without trimming it", function() {
            var inputJql = "  assignee = admin  ";
            this.view.render();
            simulateInput(this.view, inputJql);

            var readJql = this.view.readRawJql();

            equal(inputJql, readJql);
        });

        test("It triggers the 'searchChanged' when the Jql changes", function() {
            var existingJql = "projecdt = DEMO";
            var newJql = "project = BULK";
            var eventHandler = this.spy();
            this.view.on('searchChanged', eventHandler);
            this.view.render();
            this.view._getInputField().val(existingJql);

            simulateInput(this.view, newJql);

            sinon.assert.calledOnce(eventHandler);
            sinon.assert.calledWith(eventHandler, {newJql: newJql});
        });


        // Tests for auto-resizing textarea

        module('jira/components/query/jql/jqlqueryview (Resizing)', {
            setup: function() {
                this.$el = jQuery('<div>').appendTo('body');
                this.queryModule = TestUtils.mockQueryModule();
                this.queryStateModel = TestUtils.mockQueryStateModel();
                this.view = new JqlQueryView({
                    queryStateModel: this.queryStateModel,
                    el: this.$el
                });
            },
            teardown: function() {
                this.$el.remove();
            }
        });

        var getSingleLineHeight = function() {
            var queryStateModel = TestUtils.mockQueryStateModel();
            queryStateModel.setJql('a');
            var $el = jQuery('<div>').appendTo('body');
            var view = new JqlQueryView({
                queryStateModel: queryStateModel,
                el: $el
            });
            var height = view._getInputField().height();
            $el.remove();
            return height;
        };

        // Call immediately after rendering to get fitted initial height since -
        // expandOnInput doesn't shrink - only expands, and
        // different browsers have different default heights for <textarea>
        function resize(view) {
            view._getInputField().height(0)
                .trigger('keydown')
                .trigger('keypress')
                .trigger('keyup')
                .trigger('input');
        }

        function simulateInput(view, text) {
            view._getInputField().val(text)
                .trigger('keydown')
                .trigger('keypress')
                .trigger('keyup')
                .trigger('input');
        }

        test("Auto-resize on input", 2, function() {
            this.view.render();
            resize(this.view);
            simulateInput(this.view, "assignee = \n admin");
            var $input = this.view.$el.find("textarea");
            ok($input.height() > getSingleLineHeight(), "Input expanded");
            equal($input.innerHeight(), $input[0].scrollHeight, "No scrollbars");
        });

        test("Auto-resize on input is stable", function() {
            var instance = this;
            this.view.render();
            var $input = instance.view._getInputField();
            resize(instance.view);
            simulateInput(instance.view, "a");
            var height = $input.height();
            simulateInput(instance.view, "aa");
            equal($input.height(), height, "Input height stayed the same");
        });

        test("Auto-resize on render", 2, function() {
            this.queryStateModel.setJql("aaaaaaaa\nbbbbbbbb\nccccccc\ndddddddd\neeeeeeee\nffffffff\nggggggggg");
            var instance = this;
            this.view.render();
            var singleLineHeight = getSingleLineHeight();
            var $input = instance.view._getInputField();
            ok($input.height() > singleLineHeight, "Input expanded");
            equal($input.innerHeight(), $input[0].scrollHeight, "No scrollbars");
        });

        test("Auto-resize keeps same height on search", function() {
            var instance = this;
            this.view.render();
            var $input = instance.view._getInputField();
            resize(instance.view);
            simulateInput(instance.view, "assignee \n= admin");
            var twoLineHeight = $input.height();
            instance.view.readJql();
            equal($input.height(), twoLineHeight, "Same height");
        });

        test("Auto-resize to trimmed JQL on search", function() {
            var instance = this;
            this.view.render();
            var $input = instance.view._getInputField();
            resize(instance.view);

            simulateInput(instance.view, "assignee \n= admin");
            var twoLineHeight = $input.height();

            simulateInput(instance.view, "assignee \n= admin\n\n\n");
            ok($input.height() > twoLineHeight, "Expanded to accomodate trailing new lines");
            equal($input.innerHeight(), $input[0].scrollHeight, "No scrollbars for trailing new lines");
            instance.view.readJql();
            equal($input.height(), twoLineHeight, "Resized to fit trimmed JQL on search");
            equal($input.innerHeight(), $input[0].scrollHeight, "No scrollbars after trimming trailing new lines");
        });

        test("Auto-resize on model's jql change", function() {
            this.queryStateModel.setJql('foo');
            var $input = this.view.render()._getInputField();
            resize(this.view);
            var initialHeight = $input.height();
            this.queryStateModel.setJql('foo\nbar');
            ok($input.height() > initialHeight, "Expanded in response to model change");
        });
    });
});
