define("jira/components/query/jql/jqlquerymodule", ["require"], function(require) {
    "use strict";

    var _ = require("jira/components/libs/underscore");
    var Brace = require("jira/components/libs/brace");
    var JqlQueryView = require("jira/components/query/jql/jqlqueryview");
    var Events = require("jira/util/events");
    var Types = require("jira/util/events/types");
    var Reasons = require("jira/util/events/reasons");

    /**
     * Module for JQL query mode
     */
    return Brace.Evented.extend({

        namedEvents: ["searchRequested", "verticalResize", "searchChanged"],

        initialize: function(options) {

            this._queryStateModel = options.queryStateModel;
            this.view = new JqlQueryView({
                queryStateModel: options.queryStateModel
            })
                .onVerticalResize(this.triggerVerticalResize, this)
                .onSearchRequested(this.triggerSearchRequested, this)
                .onSearchChanged(this.triggerSearchChanged, this);

            /* Absolute hack to prevent DESK-1623 - after return to search, the jql box is thin cause issue nav is hidden when
             rendered so height calculation is wrong. We need to trigger it to recalculate height on return to search.
             I have added a method, refreshLayout to the query component which we now call from issue-nav-plugin
             SearchPageModule, however jira can be using a newer version of issue-nav-components that issue-nav-plugin
             (installed via service desk). So we need this nasty hack until the minimum version of jira service desk
             supports has the updateLayout call inside of SearchPageModule.
             */
            Events.bind(Types.NEW_CONTENT_ADDED, _.bind(function(e, el, reason) {
                if (reason === Reasons.returnToSearch) {
                    this.setQuery();
                }
            }, this));
        },

        search: function() {
            var jql = this.view.readJql();
            this.triggerSearchRequested(jql);
        },

        setQuery: function() {
            this.view.setQuery();
        },

        createView: function() {
            return this.view;
        }
    });
});
