define("jira/components/pager/views/pager", ['require'], function (require) {
    "use strict";

    var Marionette = require('jira/components/libs/marionette-2.1.0');
    var Templates = require('jira/components/pager/templates');
    var AJSHelper = require("jira/components/utils/ajshelper");

    return Marionette.ItemView.extend({
        getTemplate: function() {
            if (this.searchResults && this.searchResults.selected) return Templates.Pager;
            else return false;
        },

        ui: {
            "next": ".next a",
            "previous": ".previous a",
            "nextIcon": ".next span.icon"
        },

        triggers: {
            "simpleClick @ui.next": "next",
            "simpleClick @ui.previous": "previous"
        },

        update: function(searchResults) {
            this.searchResults = searchResults;
            // Backbone usually delegates DOM events when the View is constructed, not when it is rendered.
            // As we have variable templates (i.e. the first time we render the view the template is likely
            // to be undefined), we need to re-delegate the events every time we render.
            this.undelegateEvents();
            this.render();
            this.delegateEvents();
        },

        onRender: function() {
            if(this.searchResults && this.searchResults.selected) {
                var lastIssue = this.searchResults.getIssueAtGlobalIndex(this.searchResults.allIssues.length - 1);

                if (lastIssue.id === this.searchResults.selected.id && this.searchResults.isAtTheEndOfStableSearch()) {
                    this.ui.nextIcon.tooltip({
                        gravity: 'ne'
                    });
                }
            }

            var shortcuts = AJSHelper.activeShortcuts();
            if (shortcuts) {
                if (shortcuts.j && this.ui.next.length) { shortcuts.j._addShortcutTitle(this.ui.next);}
                if (shortcuts.k && this.ui.previous.length) { shortcuts.k._addShortcutTitle(this.ui.previous);}
            }
        },

        serializeData: function() {
            var model = this.searchResults;

            var selected = model.selected;
            if (!selected) return;

            var currentIssuePosition = this.searchResults.getPositionOfIssueInSearchResults(this.searchResults.selected.id);
            var templateData = {
                position: currentIssuePosition + 1,
                resultCount: this.searchResults.getTotalIssuesInDb()
            };

            var nextIssue = this.searchResults.getIssueAtGlobalIndex(currentIssuePosition + 1);
            if (nextIssue) {
                templateData.nextIssue = {
                    id: nextIssue.id,
                    key: nextIssue.key
                };
            } else if (this.searchResults.isAtTheEndOfStableSearch()) {
                templateData.isAtTheEndOfStableSearch = true;
                templateData.stableSearchCount = this.searchResults.allIssues.length;
            }

            var previousIssue = this.searchResults.getIssueAtGlobalIndex(currentIssuePosition - 1);
            if (previousIssue) {
                templateData.previousIssue = {
                    id: previousIssue.id,
                    key: previousIssue.key
                };
            }

            return templateData;
        }
    });
});
