AJS.test.require("com.atlassian.jira.jira-issue-nav-components:pager-test", function() {
    "use strict";

    var Results = require("jira/components/search/results");
    var PagerView = require("jira/components/pager/views/pager");
    var jQuery = require("jquery");
    var AJSHelper = require("jira/components/utils/ajshelper");

    var ISSUES = [
        {
            id: 1,
            key: 'DEMO-1',
            summary: 'The first issue in the project',
            status: "Open",
            type: {
                name: 'bug',
                description: 'A bug in your application',
                icon: 'iconUrl.png'
            }
        },
        {
            id: 2,
            key: 'DEMO-2',
            summary: 'The second issue in the project',
            status: "Open",
            type: {
                name: 'bug',
                description: 'A bug in your application',
                icon: 'iconUrl.png'
            }
        },
        {
            id: 3,
            key: 'DEMO-3',
            summary: 'The third issue in the project',
            status: "Open",
            type: {
                name: 'bug',
                description: 'A bug in your application',
                icon: 'iconUrl.png'
            }
        },
        {
            id: 4,
            key: 'DEMO-4',
            summary: 'The fourth issue in the project',
            status: "Open",
            type: {
                name: 'bug',
                description: 'A bug in your application',
                icon: 'iconUrl.png'
            }
        }
    ];
    var ISSUES_IN_DB = 5;

    module("jira/components/pager", {
        setup: function() {
            this.sandbox = sinon.sandbox.create();

            this.model = new Results(ISSUES, {
                issues: _.map(ISSUES, function(issue) { return {id: issue.id, key: issue.key}; } ),
                pageSize: 2,
                totalRecordsInSearch: ISSUES.length,
                totalRecordsInDB: ISSUES_IN_DB,
                jql: "project=DEMO"
            });

            this.el = jQuery("<div></div>");

            this.view = new PagerView({
                el: this.el
            });

            this.sandbox.spy(AJS, "format");
        },

        teardown: function() {
            this.sandbox.restore();
        },

        mockKbShortcuts: function() {
            var shortcuts = [
                {
                    "keys": [["j"]],
                    "context": "issuenavigation",
                    "op": "evaluate",
                    "param": ""
                },
                {
                    "keys": [["k"]],
                    "context": "issuenavigation",
                    "op": "evaluate",
                    "param": ""
                }
            ];
            this.stub(AJSHelper, "activeShortcuts").returns(AJSHelper.whenIType().fromJSON(shortcuts));
        }
    });

    test("It shows the selected issue number", function() {
        this.model.select("DEMO-3");

        this.view.update(this.model);

        sinon.assert.calledWith(AJS.format, "pager.results.displayissues.short", 3);
    });

    test("It shows the selected issue number when the first issue is selected", function() {
        this.model.select("DEMO-1");

        this.view.update(this.model);

        sinon.assert.calledWith(AJS.format, "pager.results.displayissues.short", 1);
    });

    test("It shows the selected issue number when the last issue is selected", function() {
        this.model.select("DEMO-4");

        this.view.update(this.model);

        sinon.assert.calledWith(AJS.format, "pager.results.displayissues.short", 4);
    });

    test("It shows the total number of issues in the database", function() {
        this.model.select("DEMO-1");

        this.view.update(this.model);

        sinon.assert.calledWith(AJS.format, "pager.results.displayissues.short", 1, ISSUES_IN_DB);
    });

    test("It shows a tooltip when the end of stable search has been reached and there are more issues available", function() {
        this.model.jumpToPage(1);
        this.model.select("DEMO-4");

        this.view.update(this.model);

        sinon.assert.calledWith(AJS.format, "issues.components.pager.endofstablesearch", 4);
        equal("issues.components.pager.endofstablesearch", this.view.ui.nextIcon.attr('original-title'));
    });

    test("It doesn't show the tooltip when not at the end of stable search", function() {
        this.model.jumpToPage(1);
        this.model.select("DEMO-3");

        this.view.update(this.model);

        sinon.assert.notCalled(AJS.format.withArgs("issues.components.pager.endofstablesearch"));
    });

    test("It doesn't show the tooltip when there are no more issues", function() {
        this.model.jumpToPage(1);
        this.model.select("DEMO-4");
        this.model.totalRecordsInDB = 4;

        this.view.update(this.model);

        sinon.assert.notCalled(AJS.format.withArgs("issues.components.pager.endofstablesearch"));
    });

    test("It adds the kb shortcut information to the tooltips", function() {
        this.mockKbShortcuts();
        this.model.select("DEMO-3");

        this.view.update(this.model);

        ok(this.view.ui.next.attr('title').indexOf("keyboard.shortcuts.type 'j'") > -1);
        ok(this.view.ui.previous.attr('title').indexOf("keyboard.shortcuts.type 'k'") > -1);
    });

});
