define("jira/components/orderby/orderbyview", ["require"], function(require) {
    "use strict";

    var _ = require("jira/components/libs/underscore");
    var Brace = require("jira/components/libs/brace");
    var jQuery = require("jquery");
    var Events = require("jira/util/events");
    var OrderByEventTypes = require("jira/components/orderby/eventtypes");
    var OrderByTemplates = require("jira/components/orderby/templates");
    var OrderByDropDownView = require("jira/components/orderby/orderbydropdownview");

    /**
     * The order by view that's shown over the list of issues in split view.
     *
     * @type JIRA.Issues.OrderByView
     */
    return Brace.View.extend({

        template: OrderByTemplates.orderBy,

        events: {
            "click a.order-by": "_onClickOrderBy",
            "click a.order-options": "_toggleShowDropDown"
        },

        initialize: function() {
            // Whenever the sort jql changes then we re-render
            this.model.on("change:sortBy", this.render, this);
        },

        /**
         * Renders this view base on the SearchResults' 'sortBy' property.
         *
         * @return {JIRA.Issues.OrderByView}
         */
        render: function() {
            this.$el.html(this.template(this.model.toJSON()));
            return this;
        },

        deactivate: function() {
            // make sure we cleanup events when we switch to list view
            if (this.orderByDropDown) {
                this.orderByDropDown.deactivate();
            }
            this.undelegateEvents();
        },

        /**
         * Toggles sort between ASC/DESC
         * @param e
         */
        _onClickOrderBy: function(e) {
            var event = new jQuery.Event(OrderByEventTypes.ISSUE_TABLE_REORDER);
            Events.trigger(event);
            if (!event.isDefaultPrevented()) {
                var fieldId = jQuery(e.currentTarget).data('field-id');
                if (fieldId) {
                    this.model.toggleSort();
                }
            }
            e.preventDefault();
        },
        /**
         * Hiding/Showing of sparkler
         */
        _toggleShowDropDown: function(e) {
            if (!this.orderByDropDown) {
                // lazy create
                this.orderByDropDown = new OrderByDropDownView({
                    model: this.model,
                    offsetTarget: this.$('a.order-by'),
                    onHideCallback: _.bind(function() {
                        this.orderByDropDown = null;
                    }, this)
                });
            }
            this.orderByDropDown.toggle();
            e.preventDefault();
        }

    });
});
