AJS.test.require("com.atlassian.jira.jira-issue-nav-components:orderby", function() {
    "use strict";

    require([
        "jquery",
        "jira/util/events",
        "jira/components/orderby/eventtypes",
        "jira/components/orderby/orderbyview",
        "jira/components/orderby/orderbymodel"
    ], function(
        jQuery,
        Events,
        OrderByEventTypes,
        OrderByView,
        OrderByModel
    ) {
        module("jira/components/orderby/orderbyview", {
            setup: function() {
                this.sandbox = sinon.sandbox.create();
                this.view = new OrderByView({
                    model: new OrderByModel()
                });
            },
            teardown: function() {
                this.sandbox.restore();
                delete this.view;
            }
        });

        test("Sort event is being prevented correctly", function() {
            var mockEvent = {
                preventDefault: jQuery.noop,
                currentTarget: jQuery('<div data-field-id="test"></div>')
            };

            this.sandbox.stub(OrderByModel.prototype, "toggleSort");

            Events.bind(OrderByEventTypes.ISSUE_TABLE_REORDER, jQuery.noop);
            this.view._onClickOrderBy(mockEvent);
            equal(OrderByModel.prototype.toggleSort.callCount, 1, "Default behavior is executed as expected");

            Events.bind(OrderByEventTypes.ISSUE_TABLE_REORDER, function(e) {
                e.preventDefault();
            });
            this.view._onClickOrderBy(mockEvent);
            equal(OrderByModel.prototype.toggleSort.callCount, 1, "Default behavior is prevented successfully");
        });
    });
});
