AJS.test.require("com.atlassian.jira.jira-issue-nav-components:orderby", function() {
    "use strict";

    require([
        "jquery",
        "jira/util/events",
        "jira/ajs/layer/inline-layer",
        "jira/components/orderby/eventtypes",
        "jira/components/orderby/orderbydropdownview",
        "jira/components/orderby/orderbymodel"
    ], function(
        jQuery,
        Events,
        InlineLayer,
        OrderByEventTypes,
        OrderByDropDownView,
        OrderByModel
    ) {
        module("jira/components/orderby/orderbydropdownview", {
            setup: function() {
                this.sandbox = sinon.sandbox.create();
                this.clock = this.sandbox.useFakeTimers();

                this.view = new OrderByDropDownView({
                    model: new OrderByModel(),
                    //offsetTarget: this.$('a.order-by'),
                    onHideCallback: sinon.stub()
                });
                this.view.selectControl = {};
            },
            teardown: function() {
                this.sandbox.restore();
                delete this.view;
            }
        });

        test("Sort event is being prevented correctly", function() {
            var mockEvent = {
                preventDefault: jQuery.noop
            };
            var mockDescriptior = {
                meta: function() {
                    return {sortJql: true};
                }
            };

            InlineLayer.current = {hide: this.sandbox.stub()};
            this.sandbox.stub(OrderByModel.prototype, "doSort");

            Events.bind(OrderByEventTypes.ISSUE_TABLE_REORDER, jQuery.noop);
            this.view._onFieldSelected(mockEvent, mockDescriptior);
            this.clock.tick(10);
            equal(this.view.model.doSort.callCount, 1, "Default behavior is executed as expected");

            Events.bind(OrderByEventTypes.ISSUE_TABLE_REORDER, function(e) {
                e.preventDefault();
            });
            this.view._onFieldSelected(mockEvent, mockDescriptior);
            this.clock.tick(10);
            equal(this.view.model.doSort.callCount, 1, "Default behavior is prevented successfully");
        });
    });
});
