define("jira/components/orderby", ["require"], function(require) {
    "use strict";

    var OrderByView = require("jira/components/orderby/orderbyview");
    var OrderByModel = require("jira/components/orderby/orderbymodel");

    return {

        create: function(options) {

            var model;
            var view;

            options = options || {};

            model = new OrderByModel({
                sortBy: options.sortBy,
                jql: options.jql
            });
            view = new OrderByView({model: model});

            // publish public api
            return {
                onSort: function() {
                    model.onSort.apply(model, arguments);
                    return this;
                },
                offSort: function(method) {
                    model.off("sort", method);
                    return this;
                },
                render: function() {
                    view.render();
                    return this;
                },
                setElement: function(el) {
                    view.setElement(el);
                    return this;
                },
                getJql: function() {
                    return model.getJql();
                },
                setJql: function(jql) {
                    model.setJql(jql);
                    return this;
                },
                setSortBy: function(options) {
                    model.setSortBy(options);
                    return this;
                }
            };
        }
    };
});
