define('jira/components/libs/marionette-1.4.1/mixins', ["require"], function(require) {
    "use strict";

    var _ = require('jira/components/libs/underscore');

    /**
     * @class JIRA.Marionette.Mixins
     */
    return {

        /**
         * Listen events from a source and rethrow them. By invoking this method, the current object
         * will listen (using {@link Backbone.Events.listenTo}) to those events and trigger them
         * (using {@link Backbone.Events.trigger}) with all the arguments.
         *
         * In other words, this method is a shorthand for:
         *
         *     this.listenTo(obj, "event", function(arg1, arg2, ...) {
         *         this.trigger("event", arg1, arg2, ...);
         *     }
         *
         * @param {Backbone.Events} source Object that will fire the events
         * @param {string|string[]} events Event or list of events to listen for
         */
        listenAndRethrow: function(source, events) {
            events = [].concat(events);
            _.each(events, function(event) {
                this.listenTo(source, event, function() {
                    this.trigger.apply(this, [event].concat(_.toArray(arguments)));
                }, this);
            }, this);
        },

        /**
         * Triggers a preventable event.
         *
         * The event will include an EventObject, and the handler can call
         * eventObject.preventDefault() to prevent the event.
         *
         * @param {string} eventName Name of the event being triggered.
         * @param {EventObject} [eventObject] EventObject used as template to
         * construct the actual EventObject used in the event.
         *
         * @returns {EventObject} EventObject passed to the event.
         *
         * Backported from our Marionette-2.1.0 mixins
         */
        triggerPreventable: function (eventName, eventObject) {
            /**
             * EventObject passed to preventable events
             * @typedef {Object} EventObject
             * @property {Object} emitter Original emitter of the event.
             * @property {boolean} isPrevented Whether the event has been prevented by the event handler.
             * @property {Function} preventDefault Syntax sugar for set the `isPrevented` value.
             */
            var event = _.defaults({}, eventObject || {}, {
                isPrevented: false,
                emitter: this,
                preventDefault: function () {
                    this.isPrevented = true;
                }
            });

            this.trigger(eventName, event);
            return event;
        }
    };
});
AJS.namespace("JIRA.Marionette.Mixins", null, require('jira/components/libs/marionette-1.4.1/mixins'));
