AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:marionette-1.4.1","com.atlassian.jira.jira-issue-nav-components:testutils"],function(){require(["jira/components/libs/underscore","jira/components/libs/marionette-1.4.1/dialogview","jira/dialog/form-dialog"],function(b,a,c){var d=AJS.test;module("jira/components/libs/marionette-1.4.1/dialogview",{setup:function(){this.sandbox=sinon.sandbox.create();var e=d.mockableModuleContext();this.spiedFormDialog=this.sandbox.spy(c);e.mock("jira/dialog/form-dialog",this.spiedFormDialog);this.MockedDialogViewConstructor=e.require("jira/components/libs/marionette-1.4.1/dialogview")},teardown:function(){this.sandbox.restore()},renderDialog:function(e){e.render();JIRA.Issues.Components.TestUtils.moveDialogToQunitFixture(e)},closeDialogWithCancel:function(e){e.dialog.$popup.find("#aui-dialog-close").click()},submitDialog:function(e){e.dialog.$form.submit()}});test("When rendered, it triggers the before:render event",function(){var f=new a();var e=this.spy();f.on("before:render",e);this.renderDialog(f);sinon.assert.calledOnce(e)});test("When rendered, it runs the onBeforeRender method",function(){var f=this.spy();var e=new (a.extend({onBeforeRender:f}))();this.renderDialog(e);sinon.assert.calledOnce(f)});test("When rendered, it triggers the render event",function(){var e=new a();var f=this.spy();e.on("render",f);this.renderDialog(e);sinon.assert.calledOnce(f)});test("When rendered, it runs the onRender method",function(){var f=this.spy();var e=new (a.extend({onRender:f}))();this.renderDialog(e);sinon.assert.calledOnce(f)});test("When rendered, it creates a new FormDialog when rendering",function(){var e=new this.MockedDialogViewConstructor();this.renderDialog(e);ok(this.spiedFormDialog.calledWithNew())});test("When rendered, it passes the id the FormDialog",function(){var e=new (this.MockedDialogViewConstructor.extend({id:"myDialog"}))();this.renderDialog(e);var f=this.spiedFormDialog.firstCall.thisValue;equal(f.options.id,"myDialog")});test("When rendered, it uses the dialogOptions to create the FormDialog",function(){var e=new (this.MockedDialogViewConstructor.extend({dialogOptions:this.stub().returns({randomOption:42})}))();this.renderDialog(e);var f=this.spiedFormDialog.firstCall.thisValue;equal(f.options.randomOption,"42")});test("When rendered, it uses the dialogOptions to override default properties for the FormDialog",function(){var e=new (this.MockedDialogViewConstructor.extend({id:"myDialog",dialogOptions:this.stub().returns({id:"myRealId"})}))();this.renderDialog(e);var f=this.spiedFormDialog.firstCall.thisValue;equal(f.options.id,"myRealId")});test("When rendered, it exposes the internal FormDialog in the dialog property",function(){var e=new a();this.renderDialog(e);ok(e.dialog instanceof c)});test("When rendered, It serialises the data from the model",function(){var e={toJSON:this.spy()};var f=new a({model:e});this.renderDialog(f);sinon.assert.calledOnce(e.toJSON)});test("When rendered, it uses the template to generate the dialog's content",function(){var f=this.spy();var e=new (a.extend({template:f}))();this.renderDialog(e);sinon.assert.calledOnce(f)});test("When rendered, it displays the dialog",function(){var e=new a();this.stub(JIRA.FormDialog.prototype,"show");this.renderDialog(e);sinon.assert.calledOnce(JIRA.FormDialog.prototype.show)});test("When rendered, it captures the main element",function(){var e=new a();this.renderDialog(e);equal(e.$el.length,1)});test("When closed, it closes the view if the dialog has been closed because the 'Cancel' link",function(){var e=new a();this.spy(a.prototype,"close");this.renderDialog(e);this.closeDialogWithCancel(e);sinon.assert.calledOnce(a.prototype.close)});test("When closed, it triggers the before:close event",function(){var e=new a();var f=this.spy();e.on("before:close",f);this.renderDialog(e);e.close();sinon.assert.calledOnce(f)});test("When closed, it triggers the close event",function(){var e=new a();var f=this.spy();e.on("close",f);this.renderDialog(e);e.close();sinon.assert.calledOnce(f)});test("When closed, it runs the onBeforeClose method",function(){var e=this.spy();var f=new (a.extend({onBeforeClose:e}))();this.renderDialog(f);f.close();sinon.assert.calledOnce(e)});test("When closed, it runs the onClose method",function(){var e=this.spy();var f=new (a.extend({onClose:e}))();this.renderDialog(f);f.close();sinon.assert.calledOnce(e)});test("When closed, it stops the closing action when instructed by the beforeClose method",function(){var e=this.stub().returns(false);var f=this.spy();var g=new (a.extend({onBeforeClose:e,onClose:f}))();this.renderDialog(g);g.close();sinon.assert.calledOnce(e);sinon.assert.notCalled(f)});test("When closed, it hides the dialog",function(){var e=new a();this.stub(JIRA.FormDialog.prototype,"hide");this.renderDialog(e);e.close();sinon.assert.calledWith(JIRA.FormDialog.prototype.hide,true)});test("When closed, it destroys the dialog",function(){var e=new a();this.stub(JIRA.FormDialog.prototype,"destroy");this.renderDialog(e);e.close();sinon.assert.called(JIRA.FormDialog.prototype.destroy)});test("When closed, it removes itself from the DOM",function(){var e=new a();this.spy(a.prototype,"remove");this.renderDialog(e);e.close();sinon.assert.calledOnce(a.prototype.remove)});test("When submitting, it delegates the form data generation to the formToRequestData method",function(){var f=this.spy();var e=new (a.extend({formToRequestData:f,template:function(){return"<form></form>"}}))();this.renderDialog(e);this.submitDialog(e);sinon.assert.calledOnce(f)});test("When submitting, it passes the form element to the formToRequestData method",function(){var f=this.spy();var e=new (a.extend({formToRequestData:f,template:function(){return"<form></form>"}}))();this.renderDialog(e);this.submitDialog(e);sinon.assert.calledWith(f,e.dialog.$form)});test("When submitting the form successfully, it triggers the submit:success event",function(){this.server=this.sandbox.useFakeServer();var f=new (a.extend({template:function(){return"<form method='POST'></form>"}}))();var e=this.spy();f.on("submit:success",e);this.renderDialog(f);this.submitDialog(f);b.last(this.server.requests).respond(200);sinon.assert.calledOnce(e)});test("When submitting the form successfully, it runs the onSubmitSuccess method",function(){this.server=this.sandbox.useFakeServer();var f=this.spy();var e=new (a.extend({template:function(){return"<form method='POST'></form>"},onSubmitSuccess:f}))();this.renderDialog(e);this.submitDialog(e);b.last(this.server.requests).respond(200);sinon.assert.calledOnce(f)});test("When submitting the form successfully, it closes the form",function(){this.server=this.sandbox.useFakeServer();var e=new (a.extend({template:function(){return"<form method='POST'></form>"}}))();var f=this.spy();e.on("close",f);this.renderDialog(e);this.submitDialog(e);b.last(this.server.requests).respond(200);sinon.assert.calledOnce(f)});test("When submitting the form unsuccessfully, it triggers the submit:error event",function(){this.server=this.sandbox.useFakeServer();var f=new (a.extend({template:function(){return"<form method='POST'></form>"}}))();var e=this.spy();f.on("submit:error",e);this.renderDialog(f);this.submitDialog(f);b.last(this.server.requests).respond(500);sinon.assert.calledOnce(e)});test("When submitting the form unsuccessfully, it runs the onSubmitError method",function(){this.server=this.sandbox.useFakeServer();var f=this.spy();var e=new (a.extend({template:function(){return"<form method='POST'></form>"},onSubmitError:f}))();this.renderDialog(e);this.submitDialog(e);b.last(this.server.requests).respond(500);sinon.assert.calledOnce(f)});test("When submitting the form unsuccessfully, it does not close the form",function(){this.server=this.sandbox.useFakeServer();var e=new (a.extend({template:function(){return"<form method='POST'></form>"}}))();var f=this.spy();e.on("close",f);this.renderDialog(e);this.submitDialog(e);b.last(this.server.requests).respond(500);sinon.assert.notCalled(f)});test("When submitting the form unsuccessfully, it clean ups the DOM",function(){this.server=this.sandbox.useFakeServer();var e=new (a.extend({template:function(){return"<form method='POST'></form>"}}))();this.renderDialog(e);this.submitDialog(e);b.last(this.server.requests).respond(500);equal(e.dialog.getButtonsContainer().find("input:disabled").length,0,"No disabled buttons");equal(e.dialog.getButtonsContainer().find(".throbber.loading").length,0,"No spinner");ok(!e.dialog.$form.hasClass("submitting"),"No submitting class")});test("When submitting the form unsuccessfully, it shows the field errors",function(){this.server=this.sandbox.useFakeServer();var e=new (a.extend({template:function(){return"<form method='POST'><input id='name'/></form>"}}))();this.renderDialog(e);this.submitDialog(e);b.last(this.server.requests).respond(500,{},JSON.stringify({errors:{name:"Field is duplicated"}}));equal(e.dialog.$form.find(".error").text(),"Field is duplicated")});test("When submitting the form unsuccessfully, it shows the generic errors",function(){this.server=this.sandbox.useFakeServer();var e=new (a.extend({template:function(){return"<form method='POST'><div class='aui-messages'></div></form>"}}))();this.renderDialog(e);this.submitDialog(e);b.last(this.server.requests).respond(500,{},JSON.stringify({errorMessages:["Server is down"]}));equal(e.dialog.$form.find(".aui-messages").text(),"Server is down")});test("When submitting the form unsuccessfully, it shows the XHR errors",function(){this.server=this.sandbox.useFakeServer();var e=new (a.extend({template:function(){return"<form method='POST'><div class='aui-messages'></div></form>"}}))();this.renderDialog(e);this.submitDialog(e);b.last(this.server.requests).respond(500);equal(e.dialog.$form.find(".aui-messages").find(".ajaxerror").length,1)});test("When submitting the form unsuccessfully twice, it clean the old field errors",function(){this.server=this.sandbox.useFakeServer();var e=new (a.extend({template:function(){return"<form method='POST'><input id='name'/></form>"}}))();this.renderDialog(e);this.submitDialog(e);b.last(this.server.requests).respond(500,{},JSON.stringify({errors:{name:"Field is duplicated"}}));equal(e.dialog.$form.find(".error").text(),"Field is duplicated","First error is rendered");this.submitDialog(e);b.last(this.server.requests).respond(500,{},JSON.stringify({errors:{name:"Field is duplicated dude!"}}));equal(e.dialog.$form.find(".error").text(),"Field is duplicated dude!","The second error overwrites the first one")});test("When submitting the form unsuccessfully twice, it clean the old generic errors",function(){this.server=this.sandbox.useFakeServer();var e=new (a.extend({template:function(){return"<form method='POST'><div class='aui-messages'></div></form>"}}))();this.renderDialog(e);this.submitDialog(e);b.last(this.server.requests).respond(500,{},JSON.stringify({errorMessages:["Server is down"]}));this.submitDialog(e);b.last(this.server.requests).respond(500,{},JSON.stringify({errorMessages:["Server is still down"]}));equal(e.dialog.$form.find(".aui-messages").text(),"Server is still down")})})});