define('jira/components/libs/marionette-1.4.1/application', ['require'], function (require) {
    "use strict";

    var _ = require('jira/components/libs/underscore');
    var Marionette = require('jira/components/libs/marionette-1.4.1');

    /**
     * @class JIRA.Marionette.Application
     * @extends Marionette.Application
     *
     * Main Application for JIRA.
     */
    return Marionette.Application.extend({
        /**
         * Override the constructor. We need this dumb method to be able to tests
         * the constructor.
         *
         * @constructor
         * @param {Object} [options] Options to pass to the real Application constructor.
         */
        constructor: function(options) {
            Marionette.Application.call(this, options);
        },

        /**
         * Starts the application
         *
         * @param {Object} [options] Object to pass to all initializer functions and initialize events.
         * @param {Object} [options.forceStop=true] Call stop() on all modules before starting them again.
         */
        start: function(options) {
            if (!options || options.forceStop !== false) {
                this.stop();
            }
            Marionette.Application.prototype.start.call(this, options);
        },

        /**
         * Stops all the modules
         */
        stop: function() {
            _.invoke(this.submodules, "stop");
        }
    });
});
AJS.namespace("JIRA.Marionette.Application", null, require('jira/components/libs/marionette-1.4.1/application'));
