AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:issueviewer", "com.atlassian.jira.jira-issue-nav-components:issueviewer-test"], function() {
    "use strict";

    require([
        "jquery",
        "jira/components/issueviewer/views/issuepanels",
        "jira/components/issueviewer/views/issuepanel",
        "jira/components/issueviewer/entities/panels"
    ], function(
        $,
        IssuePanelsView,
        IssuePanelView,
        PanelsCollection
    ) {
        module("jira/components/issueviewer/views/issuepanels", {
            setup: function() {
                this.el = jQuery("<div><div id='aModule' class='module'></div></div>");
                this.panels = new PanelsCollection([]);
                this.issuePanelsView = new IssuePanelsView({
                    el: this.el,
                    collection: this.panels
                });
            }
        });

        test("When applying the view to the DOM, it calls applyToDom in the children views", function() {
            this.spy(IssuePanelView.prototype, "applyToDom");

            this.issuePanelsView.applyToDom();

            sinon.assert.calledOnce(IssuePanelView.prototype.applyToDom);
        });
    });

});
