AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:issueviewer", "com.atlassian.jira.jira-issue-nav-components:issueviewer-test"], function() {
    "use strict";

    require([
        "jira/skate",
        "jquery",
        "jira/components/issueviewer/entities/panel",
        "jira/components/issueviewer/views/issuepanel",
        "jira/components/issueviewer/legacy/issueeventbus",
        'jira/util/events',
        'jira/util/events/types',
        'jira/util/events/reasons',
        'aui/params'
    ], function(
        skate,
        $,
        IssuePanelModel,
        IssuePanelView,
        IssueEventBus,
        Events,
        Types,
        Reasons,
        AJSParams
    ) {
        function jQueryElementWithId(id) {
            return sinon.match(function(arg) {
                return arg.is("#" + id);
            });
        }

        module("jira/components/issueviewer/views/issuepanel", {
            setup: function() {
                //Stop inline layer from appending to window.top so qunit iframe runner works
                AJSParams.ignoreFrame = true;
                this.el = $("<div></div>");
                this.issuePanelModel = new IssuePanelModel({entity: mockWebPanelRefPluginPanel});
                this.issuePanelView = new IssuePanelView({
                    el: this.el,
                    model: this.issuePanelModel,
                    issueEventBus: new IssueEventBus()
                });
            },
            teardown: function() {
                this.el.remove();
                if (this.$elToRemove) {
                    this.$elToRemove.remove();
                }
            }
        });

        test("Issue Web panel renders correctly with no header", function() {
            var issuePanelModel = new IssuePanelModel({entity: mockWebPanelNoHeader});
            var issuePanelView = new IssuePanelView({el: this.el, model: issuePanelModel});

            var $el = issuePanelView.render().$el;

            //make sure that we don't render a header on the client-side.
            equal($el.find(".mod-header").length, 0, "No heading means no mod-header");

            //this is actually all stuff that's in the html returned by the module.
            ok($el.is("#addcomment"), "Rendered element contains correct id");
            equal($el.find(".mod-content").length, 1, "Rendered element contains mod-content");
            equal($el.find("#footer-comment-button").length, 1, "Rendered element contains module contents");
        });

        test("Issue Web panel renders correctly with header", function() {
            var issuePanelModel = new IssuePanelModel({entity: mockWebPanelWithHeader});
            var issuePanelView = new IssuePanelView({el: this.el, model: issuePanelModel});

            var $el = issuePanelView.render().$el;

            //make sure that we do render a header on the client-side.
            ok($el.hasClass("toggle-wrap"));
            equal($el.find(".mod-header h2:contains(Details)").length, 1, "Header is rendered");

            //this is actually all stuff that's in the html returned by the module.
            equal($el.find(".mod-content #issuedetails").length, 1, "Rendered element contains correct mod-content");
        });

        test("Issue Web panel from the reference plugin renders correctly", function() {
            var issuePanelModel = new IssuePanelModel({entity: mockWebPanelRefPluginPanel});
            var issuePanelView = new IssuePanelView({el: this.el, model: issuePanelModel});

            var $el = issuePanelView.render().$el;
            this.$elToRemove = $el;
            $("#qunit-fixture").append($el);
            Events.trigger(Types.NEW_CONTENT_ADDED, [$el]);
            skate.init(document.getElementById("qunit-fixture"));

            //make sure that the header has the correct controls
            var $ops = $el.find("ul.ops");
            equal($ops.length, 1, "Operations list is present");
            var $opsList = $ops.children("li");
            equal($opsList.length, 3, "Correct number of operations is present");
            equal($($opsList[0]).find("a.icon-add16").length, 1, "First operation is correct");
            equal($($opsList[1]).find("a.icon-edit-sml").length, 1, "Second operation is correct");
            equal($($opsList[2]).find("a.drop-menu").length, 1, "Third operation is a dropdown");

            var $dropdown = $ops.find(".aui-dropdown-content");
            equal($dropdown.children("ul.aui-list-section").length, 3, "Dropdown contains correct subgroups");
            equal($dropdown.children("h5:contains(Drop Section)").length, 1, "Dropdown contains correct subheading");

            //check opening the dropdown works
            equal($("body > .ajs-layer #refViewIssue-drop-add-link").length, 0, "Dropdown is currently closed");
            var $ddTrigger = $($opsList[2]).find("a.drop-menu");
            $ddTrigger.click();
            equal($("body > .ajs-layer #refViewIssue-drop-add-link").length, 1, "Dropdown is currently open");

            //cleanup (should close the dropdown)
            $ddTrigger.click();
        });

        test("JRADEV-10219: Only updating sections of panel that are not in edit", function() {
            this.issuePanelView.render();
            this.issuePanelModel.update(mockWebPanelRefPluginPanelUpdated, ["versions"], ["summary", "components"]);

            equal(this.issuePanelView.$el.find("#summary-val").text(), "Summary Updated");
            equal(this.issuePanelView.$el.find("#versions-val").text(), "");
            equal(this.issuePanelView.$el.find("#components-val").text(), "Components Updated");
        });

        test("JRADEV-10219: Update entire panel if no fields in edit", function() {
            this.issuePanelView.render();

            this.issuePanelModel.update(mockWebPanelRefPluginPanelUpdated, [], ["summary"]);

            equal(this.issuePanelView.$el.find("#changed-body").text(), "Some changed body text");
            equal(this.issuePanelView.$el.find("#summary-val").text(), "Summary Updated");
            equal(this.issuePanelView.$el.find("#versions-val").text(), "Versions Updated");
            equal(this.issuePanelView.$el.find("#components-val").text(), "Components Updated");
        });

        test("Update entire panel should trigger the event 'individualPanelRendered'", function() {
            this.issuePanelView.render();
            var onIndividualPanelRendered = this.spy();
            this.issuePanelView.on("individualPanelRendered", onIndividualPanelRendered);

            this.issuePanelModel.update(mockWebPanelRefPluginPanelUpdated, [], ["summary"]);

            sinon.assert.calledOnce(onIndividualPanelRendered);
            sinon.assert.calledWith(onIndividualPanelRendered, jQueryElementWithId(mockWebPanelRefPluginPanelUpdated.id));
        });

        test("Update entire panel should trigger the event 'panelRendered'", function() {
            this.issuePanelView.render();
            var onPanelRendered = this.spy();
            this.issuePanelView.on("panelRendered", onPanelRendered);

            this.issuePanelModel.update(mockWebPanelRefPluginPanelUpdated, [], ["summary"]);

            sinon.assert.calledOnce(onPanelRendered);
            sinon.assert.calledWith(onPanelRendered,
                sinon.match.any,
                jQueryElementWithId(mockWebPanelRefPluginPanelUpdated.id),
                jQueryElementWithId(mockWebPanelRefPluginPanelUpdated.id));
        });

        test("Rendering this view should trigger the event 'individualPanelRendered'", function() {
            var onIndividualPanelRendered = this.spy();
            this.issuePanelView.on("individualPanelRendered", onIndividualPanelRendered);

            this.issuePanelView.render();

            sinon.assert.calledOnce(onIndividualPanelRendered);
        });

        test("Applying this view to an existing DOM should trigger the event 'individualPanelRendered'", function() {
            var onIndividualPanelRendered = this.spy();
            this.issuePanelView.on("individualPanelRendered", onIndividualPanelRendered);

            this.issuePanelView.applyToDom();

            sinon.assert.calledOnce(onIndividualPanelRendered);
        });
    });

});
