define("jira/components/issueviewer/views/issuebody", ["require"], function(require){
    "use strict";

    var MarionetteLayout = require('jira/components/libs/marionette-1.4.1/layout');
    var MarionetteLinkRegion = require("jira/components/libs/marionette-1.4.1/linkregion");
    var Templates = require("jira/components/issueviewer/templates");

    /**
     * @class JIRA.Components.IssueViewer.Views.IssueBody
     *
     * View used to render the body of an issue. It uses the model JIRA.Components.IssueViewer.Models.Issue.
     * This view is just a container for panels, it does not render any data by itself.
     *
     * @extend JIRA.Marionette.Layout
     */
     return MarionetteLayout.extend({
        tagName: "div",

        className: "issue-body-content",

        regions: {
            leftPanels: {
                selector: ".issue-main-column",
                regionType: MarionetteLinkRegion
            },
            rightPanels: {
                selector: ".issue-side-column",
                regionType: MarionetteLinkRegion
            },
            infoPanels: {
                selector: ".issue-body",
                regionType: MarionetteLinkRegion
            }
        },

        template: Templates.Body.issueBody
    });

});
