define("jira/components/issueviewer/views/errornotfound", ["require"], function(require){
    "use strict";

    var GenericError = require("jira/components/issueviewer/views/error");
    var Templates = require("jira/components/issueviewer/templates");
    var _ = require("jira/components/libs/underscore");

    /**
     * @class JIRA.Components.IssueViewer.Views.ErrorNotFound
     * Renders the error for a NotFound issue
     *
     * @extends JIRA.Components.IssueViewer.Views.Error
     */
    return GenericError.extend({
        template: Templates.Error.DoesNotExist,

        /**
         * Initializes this view
         *
         * @param options
         * @param {boolean|function} [options.showReturnToSearchOnError=false] Whether the error views should display a 'Return to Search' link
         */
        initialize: function(options) {
            options = options || {};
            this.showReturnToSearchOnError = options.showReturnToSearchOnError;
        },

        triggers: {
            "click #return-to-search": "returnToSearch"
        },

        serializeData: function() {
            var showReturnToSearchOnError = this.showReturnToSearchOnError;
            if (_.isFunction(showReturnToSearchOnError)) {
                showReturnToSearchOnError = showReturnToSearchOnError();
            }

            return {
                hideReturnToSearch: !showReturnToSearchOnError
            };
        }
    });

});
