define("jira/components/issueviewer/views/errorgeneric", ["require"], function(require){
    "use strict";

    var GenericError = require("jira/components/issueviewer/views/error");
    var Templates = require("jira/components/issueviewer/templates");
    var Browser = require("jira/components/util/browser");

    /**
     * @class JIRA.Components.IssueViewer.Views.ErrorGeneric
     * Renders a generic error
     *
     * @extends JIRA.Components.IssueViewer.Views.Error
     */
    return GenericError.extend({
        template: Templates.Error.Generic,
        events: {
            "click #issue-error-reload-button": function() {
                Browser.locationReload();
            }
        }
    });

});
