define("jira/components/issueviewer/linkscapturer", ["require"], function(require){
    "use strict";

    var _ = require("jira/components/libs/underscore");
    var Events = require('jira/util/events');
    var InlineLayer = require('jira/ajs/layer/inline-layer');
    var jQuery = require("jquery");
    var MarionetteController = require("jira/components/libs/marionette-1.4.1/controller");
    var Messages = require("jira/message");
    var SmartAjax = require("jira/ajs/ajax/smart-ajax");
    var URI = require('jira/components/libs/uri');

    return MarionetteController.extend({
        initialize: function() {
            _.bindAll(this,
                "_onRefineViewEvents",
                "_offRefineViewEvents",
                "_handleReviewViewEvents"
            );
        },

        capture: function(el) {
            if (el === this.el) return;

            this.el = el;
            this.linksToOtherIssues();
            this.linksToReorderSubtasks();
            this.viewOptionsForCurrentIssue();
        },

        linksToOtherIssues: function() {
            jQuery(this.el).on("simpleClick", "a.issue-link[data-issue-key]", _.bind(function (e) {
                e.preventDefault();
                var issueKey = jQuery(e.target).closest("a").data("issue-key");
                this.trigger("linkToIssue", {
                    issueKey: issueKey
                });
            }, this));
        },

        linksToReorderSubtasks: function() {
            // Enhance Attachment options links
            jQuery(this.el).on("simpleClick", ".subtask-reorder a", _.bind(function(e) {
                if (!e.target.href) return;

                e.preventDefault();

                jQuery.ajax({
                    type: "GET",
                    data: {
                        disableRedirect: true
                    },
                    url: e.target.href
                }).done(_.bind(function() {
                    this.trigger("reorderSubtasks");
                }, this)).fail(function(xhr) {
                    Messages.showErrorMsg(SmartAjax.buildSimpleErrorContent(xhr), {
                        closeable: true
                    });
                });
            }, this));
        },

        _handleReviewViewEvents: function (e) {
            var target = e.currentTarget;
            jQuery(target).parents('ul').find('a.aui-checked').removeClass('aui-checked');
            jQuery(target).addClass('aui-checked');

            var query = new URI(target.href).query(true);
            var preventableEvent = this.triggerPreventable("refineViewer", {
                query: query
            });

            if (preventableEvent.isPrevented) {
                e.preventDefault();
            }
        },

        _onRefineViewEvents: function(event, layer) {
            jQuery(layer).on("simpleClick",
                [
                    "#attachment-sorting-options a",
                    "#attachment-sorting-order-options a",
                    "#attachment-view-mode-options a",
                    "#subtasks-show-all",
                    "#subtasks-show-open"
                ].join(','),
                this._handleReviewViewEvents
            );
        },

        _offRefineViewEvents: function(event, layer) {
            jQuery(layer).off("simpleClick",
                [
                    "#attachment-sorting-options a",
                    "#attachment-sorting-order-options a",
                    "#attachment-view-mode-options a",
                    "#subtasks-show-all",
                    "#subtasks-show-open"
                ].join(','),
                this._handleReviewViewEvents
            );
        },

        viewOptionsForCurrentIssue: function() {
            Events.bind(InlineLayer.EVENTS.show, this._onRefineViewEvents);
            Events.bind(InlineLayer.EVENTS.hide, this._offRefineViewEvents);
        },

        destroy: function() {
            Events.unbind(InlineLayer.EVENTS.show, this._onRefineViewEvents);
            Events.unbind(InlineLayer.EVENTS.hide, this._offRefineViewEvents);

        }
    });
});
