define("jira/components/issueviewer/services/darkfeatures", ["require"], function(require){
    "use strict";

    var Class = require("jira/lib/class");
    var DarkFeatures = require("jira/ajs/dark-features");
    var WRMData = require("wrm/data");

    var features = WRMData.claim("com.atlassian.jira.jira-issue-nav-components:issueviewer.features");

    /**
     * Holds the dark feature switches that affect how the KA app works.
     */
    return (function() {
        var Feature = Class.extend({
            /**
             * Creates a new Feature object for the given feature key.
             *
             * @param featureKey {String} the name of the feature
             * @param featureOffKey {String} the name of the feature that negates the behaviour of featureKey.
             */
            init: function(featureKey, featureOffKey) {
                this.featureKey = featureKey;
                this.featureOffKey = featureOffKey;
            },

            /**
             * Returns true if this Feature is enabled.
             * If there is a featureOffKey present, that feature is evaluated and negated.
             *
             * @return {Boolean}
             */
            enabled: function() {
                return (!this.featureKey || DarkFeatures.isEnabled(this.featureKey)) &&
                    !(this.featureOffKey && DarkFeatures.isEnabled(this.featureOffKey));
            }
        });

        var ViewerFeature = Feature.extend({
            enabled: function() {
                return features[this.featureKey];
            }
        });

        return {
            /**
             * If enabled, kills issue prefetching.
             */
            NO_PREFETCH: new Feature("ka.NO_PREFETCH"),

            /**
             * If enabled, project's avatar will display a popup on click
             */
            PROJECT_SHORTCUTS: new Feature("rotp.project.shortcuts"),

            /**
             * If enabled, requests to the Global Issue Navigator are redirected to the Project Issue Navigator.
             */
            REDIRECT_FROM_GLOBAL_TO_PROJECT: new Feature(null, "ka.REDIRECT_FROM_GLOBAL_TO_PROJECT_OFF"),

            /**
             * If enabled, the current search is not stored in JIRA sessions, and is only stored locally. This is not
             * intended to be turned on in production on a per-rack basis or similar. Instead we plan to use it for
             * testing and maybe only have it on in production for a week or two before removing the code entirely.
             */
            HTTP_SESSIONS_DISABLED: new Feature("ka.HTTP_SESSIONS_DISABLED"),

            /**
             * If enabled, inline edit won't be saved on blur event
             */
            RTE_ENABLED: new ViewerFeature("rteEnabled")
        };
    })();

});
