AJS.test.require("com.atlassian.jira.jira-projects-issue-navigator:application-test", function () {
    "use strict";

    require([
        "jira/ajs/dark-features",
        "jira/projects/test-utils/mockutils"
    ], function (
        DarkFeatures,
        MockUtils
    ) {
        module("jira/components/issueviewer/services/darkfeatures", {
            setup: function () {
                this.features = {
                    NO_PREFETCH: {
                        ON: "ka.NO_PREFETCH"
                    },
                    PROJECT_SHORTCUTS: {
                        ON: "rotp.project.shortcuts"
                    },
                    REDIRECT_FROM_GLOBAL_TO_PROJECT: {
                        OFF: "ka.REDIRECT_FROM_GLOBAL_TO_PROJECT_OFF"
                    }
                };

                this.sandbox = sinon.sandbox.create();

                this.sandbox.spy(DarkFeatures, 'enable');
                this.sandbox.spy(DarkFeatures, 'disable');
                this.sandbox.spy(DarkFeatures, 'isEnabled');

                this.DarkFeatureService = MockUtils.requireWithMocks("jira/components/issueviewer/services/darkfeatures", {
                    "jira/ajs/dark-features": DarkFeatures
                });
            },

            teardown: function() {
                this.sandbox.restore();

                DarkFeatures.disable(this.features.REDIRECT_FROM_GLOBAL_TO_PROJECT.OFF);
            }
        });

        test("When the 'global to project OFF' redirect is enabled, it returns false", function () {
            DarkFeatures.enable(this.features.REDIRECT_FROM_GLOBAL_TO_PROJECT.OFF);

            var result = this.DarkFeatureService.REDIRECT_FROM_GLOBAL_TO_PROJECT.enabled();

            sinon.assert.calledOnce(DarkFeatures.isEnabled.withArgs(this.features.REDIRECT_FROM_GLOBAL_TO_PROJECT.OFF));
            equal(result, false);
        });

        test("When the 'global to project' redirect is disabled, it returns false", function () {
            var result = this.DarkFeatureService.REDIRECT_FROM_GLOBAL_TO_PROJECT.enabled();

            sinon.assert.calledOnce(DarkFeatures.isEnabled.withArgs(this.features.REDIRECT_FROM_GLOBAL_TO_PROJECT.OFF));
            equal(result, true);
        });
    });
});
