AJS.test.require(["com.atlassian.jira.jira-issue-nav-components:issueviewer", "com.atlassian.jira.jira-issue-nav-components:issueviewer-test"], function() {
    "use strict";

    require([
        "jira/components/issueviewer/legacy/issuefieldutil"
    ], function(
        IssueFieldUtil
    ) {
        module("jira/components/issueviewer/legacy/issuefieldutil");

        test("transformFieldHtml() handles editHtml containing scripts that produce errors", function() {
            var resp = {
                fields: [
                    {
                        id: 'testField',
                        label: 'Test Field',
                        editHtml: '<div class="description">Test</div><script>null()</script>',
                        required: true
                    }
                ]
            };
            try {
                resp = IssueFieldUtil.transformFieldHtml(resp);
                ok(true, "No exception thrown");
            } catch (e) {
                ok(false, "Transform didn't catch exception");
            }
        });

        function testTransformFieldHtml(html) {
            var resp = {
                fields: [
                    {
                        editHtml: html
                    }
                ]
            };
            var returnResp = IssueFieldUtil.transformFieldHtml(resp);
            return returnResp.fields[0].editHtml;
        }

        test("transformFieldHtml() removes <legend> from checkboxes `editHtml`", function() {
            var editHtmlWithLegend = "<div><legend></legend><input class=\"checkbox\"></div>";
            var editHtmlWithoutLegend = "<div><input class=\"checkbox\"></div>";

            var editHtmlTransformed = testTransformFieldHtml(editHtmlWithLegend);

            equal(editHtmlTransformed, editHtmlWithoutLegend, "`editHtml` still has <legend>");
        });

        test("transformFieldHtml() removes <legend> from radios `editHtml`", function() {
            var editHtmlWithLegend = "<div><legend></legend><input class=\"radio\"></div>";
            var editHtmlWithoutLegend = "<div><input class=\"radio\"></div>";

            var editHtmlTransformed = testTransformFieldHtml(editHtmlWithLegend);

            equal(editHtmlTransformed, editHtmlWithoutLegend, "`editHtml` still has <legend>");
        });

        test("transformFieldHtml() removes <label> from non-checkboxes and non-radios `editHtml`", function() {
            var editHtmlWithLabel = "<div><label for=\"foo\"></label></div>";
            var editHtmlWithoutLabel = "<div></div>";

            var editHtmlTransformed = testTransformFieldHtml(editHtmlWithLabel);

            equal(editHtmlTransformed, editHtmlWithoutLabel, "`editHtml` still has <label>");
        });
    });

});
